/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.Adjective;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.VerbFrame;
import net.didion.jwnl.dictionary.Dictionary;
import net.didion.jwnl.util.ResourceBundleSet;
import net.didion.jwnl.util.factory.Element;
import net.didion.jwnl.util.factory.NameValueParam;
import net.didion.jwnl.util.factory.Param;
import net.didion.jwnl.util.factory.ParamList;
import net.didion.jwnl.util.factory.ValueParam;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JWNL {
    public static final OS WINDOWS = new OS("windows");
    public static final OS UNIX = new OS("unix");
    public static final OS MAC = new OS("mac");
    public static final OS UNDEFINED = new OS("undefined");
    public static final OS[] DEFINED_OS_ARRAY = new OS[]{WINDOWS, UNIX, MAC};
    public static final String OS_PROPERTY_NAME = "os.name";
    private static final String JAVA_VERSION_PROPERTY = "java.version";
    private static final String CORE_RESOURCE = "JWNLResource";
    private static final int UNINITIALIZED = 0;
    private static final int START = 1;
    private static final int DICTIONARY_PATH_SET = 2;
    private static final int VERSION_SET = 3;
    private static final int INITIALIZED = 4;
    private static Version _version;
    private static ResourceBundleSet _bundle;
    private static OS _currentOS;
    private static int _initStage;
    private static final String VERSION_TAG = "version";
    private static final String DICTIONARY_TAG = "dictionary";
    private static final String PARAM_TAG = "param";
    private static final String RESOURCE_TAG = "resource";
    private static final String LANGUAGE_ATTRIBUTE = "language";
    private static final String COUNTRY_ATTRIBUTE = "country";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String PUBLISHER_ATTRIBUTE = "publisher";
    private static final String NUMBER_ATTRIBUTE = "number";

    static {
        _currentOS = UNDEFINED;
        _initStage = 0;
        JWNL.createResourceBundle();
        String os = System.getProperty(OS_PROPERTY_NAME);
        int i = 0;
        while (i < DEFINED_OS_ARRAY.length) {
            if (DEFINED_OS_ARRAY[i].matches(os)) {
                _currentOS = DEFINED_OS_ARRAY[i];
            }
            ++i;
        }
    }

    private JWNL() {
    }

    public static void initialize(InputStream propertiesStream) throws JWNLException {
        JWNL.checkInitialized(0);
        _initStage = 1;
        try {
            if (propertiesStream == null || propertiesStream.available() <= 0) {
                throw new JWNLException("JWNL_EXCEPTION_001");
            }
        }
        catch (IOException ex) {
            throw new JWNLException("JWNL_EXCEPTION_001", ex);
        }
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            doc = docBuilder.parse(propertiesStream);
        }
        catch (Exception ex) {
            throw new JWNLException("JWNL_EXCEPTION_002", ex);
        }
        try {
            propertiesStream.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        org.w3c.dom.Element root = doc.getDocumentElement();
        _bundle.setLocale(JWNL.getLocale(JWNL.getAttribute(root, LANGUAGE_ATTRIBUTE), JWNL.getAttribute(root, COUNTRY_ATTRIBUTE)));
        NodeList resourceNodes = root.getElementsByTagName(RESOURCE_TAG);
        int i = 0;
        while (i < resourceNodes.getLength()) {
            String resource = JWNL.getAttribute(resourceNodes.item(i), CLASS_ATTRIBUTE);
            if (resource != null) {
                _bundle.addResource(resource);
            }
            ++i;
        }
        PointerType.initialize();
        Adjective.initialize();
        VerbFrame.initialize();
        NodeList versionNodes = root.getElementsByTagName(VERSION_TAG);
        if (versionNodes.getLength() == 0) {
            throw new JWNLException("JWNL_EXCEPTION_003");
        }
        Node version = versionNodes.item(0);
        _initStage = 2;
        String number = JWNL.getAttribute(version, NUMBER_ATTRIBUTE);
        _version = new Version(JWNL.getAttribute(version, PUBLISHER_ATTRIBUTE), number == null ? 0.0 : Double.parseDouble(number), JWNL.getLocale(JWNL.getAttribute(version, LANGUAGE_ATTRIBUTE), JWNL.getAttribute(version, COUNTRY_ATTRIBUTE)));
        _initStage = 3;
        NodeList dictionaryNodeList = root.getElementsByTagName(DICTIONARY_TAG);
        if (dictionaryNodeList.getLength() == 0) {
            throw new JWNLException("JWNL_EXCEPTION_005");
        }
        Node n = dictionaryNodeList.item(0);
        Element e = JWNL.createElementFromNode(n);
        e.install();
        _initStage = 4;
    }

    private static void createResourceBundle() {
        _bundle = new ResourceBundleSet(CORE_RESOURCE);
        if (_bundle == null || !_bundle.getKeys().hasMoreElements()) {
            throw new RuntimeException("NULL BUNDLE: CORE_RESOURCE");
        }
    }

    private static Element createElementFromNode(Node node) throws JWNLException {
        return new Element(JWNL.getAttribute(node, CLASS_ATTRIBUTE), JWNL.getParams(node.getChildNodes()));
    }

    private static Param[] getParams(NodeList list) throws JWNLException {
        ArrayList<ParamList> params = new ArrayList<ParamList>();
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i);
            if (n.getNodeType() == 1 && n.getNodeName().equals(PARAM_TAG)) {
                String name = JWNL.getAttribute(n, NAME_ATTRIBUTE);
                String value = JWNL.getAttribute(n, VALUE_ATTRIBUTE);
                if (name == null && value == null) {
                    throw new JWNLException("JWNL_EXCEPTION_008");
                }
                Param param = null;
                param = value == null ? new ParamList(name.toLowerCase(), JWNL.getParams(n.getChildNodes())) : (name == null ? new ValueParam(value, JWNL.getParams(n.getChildNodes())) : new NameValueParam(name.toLowerCase(), value, JWNL.getParams(n.getChildNodes())));
                params.add((ParamList)param);
            }
            ++i;
        }
        return params.toArray(new Param[params.size()]);
    }

    private static String getAttribute(Node node, String attributeName) {
        Node n;
        NamedNodeMap map = node.getAttributes();
        if (map != null && (n = map.getNamedItem(attributeName)) != null) {
            return n.getNodeValue();
        }
        return null;
    }

    private static Locale getLocale(String language, String country) {
        if (language == null) {
            return Locale.getDefault();
        }
        if (country == null) {
            return new Locale(language, "");
        }
        return new Locale(language, country);
    }

    public static boolean isInitialized() {
        return _initStage == 4;
    }

    public static OS getOS() {
        return _currentOS;
    }

    public static double getJavaVersion() {
        String versionStr = System.getProperty(JAVA_VERSION_PROPERTY);
        return Double.parseDouble(versionStr.substring(0, 3));
    }

    public static Version getVersion() {
        JWNL.checkInitialized(3);
        return _version;
    }

    public static ResourceBundle getResourceBundle() {
        return _bundle;
    }

    public static String resolveMessage(String msg) {
        return JWNL.resolveMessage(msg, new Object[0]);
    }

    public static String resolveMessage(String msg, Object obj) {
        return JWNL.resolveMessage(msg, new Object[]{obj});
    }

    public static String resolveMessage(String msg, Object[] params) {
        JWNL.checkInitialized(0);
        return JWNL.insertParams(_bundle.getString(msg), params);
    }

    private static String insertParams(String str, Object[] params) {
        StringBuffer buf = new StringBuffer();
        int startIndex = 0;
        int i = 0;
        while (i < params.length && startIndex <= str.length()) {
            int endIndex = str.indexOf("{" + i, startIndex);
            if (endIndex != -1) {
                buf.append(str.substring(startIndex, endIndex));
                buf.append(params[i] == null ? null : params[i].toString());
                startIndex = endIndex + 3;
            }
            ++i;
        }
        buf.append(str.substring(startIndex, str.length()));
        return buf.toString();
    }

    private static void checkInitialized(int requiredStage) {
        if (requiredStage > _initStage) {
            throw new JWNLRuntimeException("JWNL_EXCEPTION_007");
        }
    }

    public static void shutdown() {
        _initStage = 0;
        Dictionary.uninstall();
        _version = null;
        JWNL.createResourceBundle();
    }

    public static final class OS {
        private String _name;

        protected OS(String name) {
            this._name = name;
        }

        public String toString() {
            return JWNL.resolveMessage("JWNL_TOSTRING_001", this._name);
        }

        public boolean matches(String test) {
            return test.toLowerCase().indexOf(this._name.toLowerCase()) >= 0;
        }
    }

    public static final class Version {
        private static final String UNSPECIFIED = "unspecified";
        private String _publisher;
        private double _number;
        private Locale _locale;

        public Version(String publisher, double number, Locale locale) {
            if (publisher == null) {
                publisher = UNSPECIFIED;
            }
            this._publisher = publisher;
            this._number = number;
            this._locale = locale;
        }

        public String getPublisher() {
            return this._publisher;
        }

        public double getNumber() {
            return this._number;
        }

        public Locale getLocale() {
            return this._locale;
        }

        public boolean equals(Object obj) {
            return obj instanceof Version && this._publisher.equals(((Version)obj)._publisher) && this._number == ((Version)obj)._number && this._locale.equals(((Version)obj)._locale);
        }

        public String toString() {
            return JWNL.resolveMessage("JWNL_TOSTRING_002", new Object[]{this._publisher, new Double(this._number), this._locale});
        }

        public int hashCode() {
            return this._publisher.hashCode() ^ (int)(this._number * 100.0);
        }
    }
}

