/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data.list;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.list.Node;
import net.didion.jwnl.data.list.NodePrinter;
import net.didion.jwnl.data.list.PointerTargetNodeList;
import net.didion.jwnl.data.list.PointerTargetTreeNode;

public class PointerTargetTreeNodeList
extends PointerTargetNodeList {
    private static final NodePrinter PRINTER = new NodePrinter(2){

        public void print(PrintStream stream, Node node, int indent, int indentIncrement) {
            PointerTargetTreeNode n = (PointerTargetTreeNode)node;
            char[] c = new char[indent >= 0 ? indent : 0];
            Arrays.fill(c, ' ');
            stream.println(String.valueOf(new String(c)) + n);
            if (n.hasValidChildTreeList()) {
                n.getChildTreeList().print(stream, indent + indentIncrement, indentIncrement);
            }
        }
    };
    static /* synthetic */ Class class$0;

    public PointerTargetTreeNodeList() {
        this(new LinkedList());
    }

    public PointerTargetTreeNodeList(LinkedList list) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.didion.jwnl.data.list.PointerTargetTreeNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(list, (Class)clazz);
    }

    public void add(PointerTarget target) {
        this.add(new PointerTargetTreeNode(target));
    }

    public void add(PointerTarget target, PointerType type) {
        this.add(new PointerTargetTreeNode(target, type));
    }

    public void add(PointerTarget target, PointerType type, PointerTargetTreeNode parent) {
        this.add(new PointerTargetTreeNode(target, type, parent));
    }

    public void add(PointerTarget target, PointerTargetTreeNodeList childTreeList, PointerType type) {
        this.add(new PointerTargetTreeNode(target, childTreeList, type));
    }

    public void add(PointerTarget target, PointerTargetTreeNodeList childTreeList, PointerType type, PointerTargetTreeNode parent) {
        this.add(new PointerTargetTreeNode(target, childTreeList, type, parent));
    }

    public void add(PointerTarget target, PointerTargetTreeNodeList childTreeList, PointerTargetTreeNodeList pointerTreeList, PointerType type) {
        this.add(new PointerTargetTreeNode(target, childTreeList, pointerTreeList, type));
    }

    public void add(PointerTarget target, PointerTargetTreeNodeList childTreeList, PointerTargetTreeNodeList pointerTreeList, PointerType type, PointerTargetTreeNode parent) {
        this.add(new PointerTargetTreeNode(target, childTreeList, pointerTreeList, type, parent));
    }

    protected NodePrinter getNodePrinter() {
        return PRINTER;
    }

    public Object getFirstMatch(Operation opr) {
        ListIterator itr = this.listIterator();
        Object obj = null;
        while (itr.hasNext() && obj == null) {
            PointerTargetTreeNode node = (PointerTargetTreeNode)itr.next();
            obj = opr.execute(node);
            if (obj != null) {
                return obj;
            }
            if (!node.hasValidChildTreeList()) continue;
            return node.getChildTreeList().getFirstMatch(opr);
        }
        return null;
    }

    public List getAllMatches(Operation opr) {
        ArrayList list = new ArrayList();
        this.getAllMatches(opr, list);
        return list;
    }

    public void getAllMatches(Operation opr, List matches) {
        ListIterator itr = this.listIterator();
        while (itr.hasNext()) {
            PointerTargetTreeNode node = (PointerTargetTreeNode)itr.next();
            Object obj = opr.execute(node);
            if (obj != null) {
                matches.add(obj);
            }
            if (!node.hasValidChildTreeList()) continue;
            node.getChildTreeList().getAllMatches(opr, matches);
        }
    }

    public PointerTargetTreeNode findFirst(PointerTargetTreeNode node) {
        Object obj = this.getFirstMatch(new FindNodeOperation(node));
        return obj == null ? null : (PointerTargetTreeNode)obj;
    }

    public PointerTargetTreeNode[] findAll(PointerTargetTreeNode node) {
        List v = this.getAllMatches(new FindNodeOperation(node));
        if (v == null) {
            return null;
        }
        return v.toArray(new PointerTargetTreeNode[v.size()]);
    }

    public Object clone() throws CloneNotSupportedException {
        return new PointerTargetTreeNodeList((LinkedList)this.copyBackingList());
    }

    public Object deepClone() throws UnsupportedOperationException {
        PointerTargetTreeNodeList list = new PointerTargetTreeNodeList();
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            list.add(((PointerTargetTreeNode)itr.next()).deepClone());
        }
        return list;
    }

    public static class FindNodeOperation
    implements Operation {
        private PointerTargetTreeNode _node;

        public FindNodeOperation(PointerTargetTreeNode node) {
            this._node = node;
        }

        public Object execute(PointerTargetTreeNode testNode) {
            if (this._node.equals(testNode)) {
                return testNode;
            }
            return null;
        }
    }

    public static class FindTargetOperation
    implements Operation {
        private PointerTarget _target;

        public FindTargetOperation(PointerTarget target) {
            this._target = target;
        }

        public Object execute(PointerTargetTreeNode node) {
            if (node.getPointerTarget().equals(this._target)) {
                return node;
            }
            return null;
        }
    }

    public static interface Operation {
        public Object execute(PointerTargetTreeNode var1);
    }
}

