/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary.file;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.file.AbstractDictionaryFile;
import net.didion.jwnl.dictionary.file.DictionaryFile;
import net.didion.jwnl.dictionary.file.DictionaryFileType;

public class DictionaryCatalog {
    Map _files = new HashMap();
    private DictionaryFileType _fileType;

    public DictionaryCatalog(DictionaryFileType fileType, DictionaryFile[] files) {
        this._fileType = fileType;
        int i = 0;
        while (i < files.length) {
            this._files.put(files[i].getPOS(), files[i]);
            ++i;
        }
    }

    public DictionaryCatalog(String path, DictionaryFileType fileType, Class dictionaryFileType) {
        this._fileType = fileType;
        try {
            Constructor c = dictionaryFileType.getConstructor(new Class[0]);
            DictionaryFile factory = (DictionaryFile)c.newInstance(null);
            Iterator itr = POS.getAllPOS().iterator();
            while (itr.hasNext()) {
                DictionaryFile file = factory.newInstance(path, (POS)itr.next(), fileType);
                this._files.put(file.getPOS(), file);
            }
        }
        catch (Exception ex) {
            throw new JWNLRuntimeException("DICTIONARY_EXCEPTION_0018", new Object[]{fileType, dictionaryFileType}, (Throwable)ex);
        }
    }

    public Object getKey() {
        return this.getFileType();
    }

    public void open() throws IOException {
        if (!this.isOpen()) {
            Iterator itr = this.getFileIterator();
            while (itr.hasNext()) {
                DictionaryFile df = (DictionaryFile)itr.next();
                df.open();
            }
        }
    }

    public boolean isOpen() {
        Iterator itr = this.getFileIterator();
        while (itr.hasNext()) {
            if (((DictionaryFile)itr.next()).isOpen()) continue;
            return false;
        }
        return true;
    }

    public void close() {
        Iterator itr = this.getFileIterator();
        while (itr.hasNext()) {
            ((AbstractDictionaryFile)itr.next()).close();
        }
    }

    public int size() {
        return this._files.size();
    }

    public Iterator getFileIterator() {
        return this._files.values().iterator();
    }

    public DictionaryFile get(POS pos) {
        return (DictionaryFile)this._files.get(pos);
    }

    public DictionaryFileType getFileType() {
        return this._fileType;
    }
}

