/*
 * Decompiled with CFR 0.152.
 */
package rita.wordnet;

import com.nexagis.jawbone.filter.ContainsAllFilter;
import com.nexagis.jawbone.filter.ContainsFilter;
import com.nexagis.jawbone.filter.ContainsSomeFilter;
import com.nexagis.jawbone.filter.EndsWithFilter;
import com.nexagis.jawbone.filter.ExactMatchFilter;
import com.nexagis.jawbone.filter.RegexFilter;
import com.nexagis.jawbone.filter.SimilarFilter;
import com.nexagis.jawbone.filter.SoundFilter;
import com.nexagis.jawbone.filter.StartsWithFilter;
import com.nexagis.jawbone.filter.TermFilter;
import com.nexagis.jawbone.filter.WildcardFilter;
import java.util.ArrayList;
import java.util.List;
import rita.wordnet.AnagramFilter;
import rita.wordnet.Wordnet;
import rita.wordnet.WordnetError;

public abstract class RiFilter
implements Wordnet,
TermFilter {
    protected static boolean ignoreCase = false;

    public abstract boolean accept(String var1);

    protected RiFilter() {
    }

    public static RiFilter create(int flag, String word) {
        RiFilter filter = null;
        if ((flag & 0x20) != 0) {
            filter = new ExactMatchFilter(word, ignoreCase);
        } else if ((flag & 0x10) != 0) {
            if (filter == null) {
                filter = new EndsWithFilter(word, ignoreCase);
            }
        } else if ((flag & 0x80) != 0) {
            if (filter == null) {
                filter = new StartsWithFilter(word, ignoreCase);
            }
        } else if ((flag & 1) != 0) {
            if (filter == null) {
                filter = new AnagramFilter(word, ignoreCase);
            }
        } else if ((flag & 2) != 0) {
            if (filter == null) {
                filter = new ContainsAllFilter(word, ignoreCase);
            }
        } else if ((flag & 4) != 0) {
            if (filter == null) {
                filter = new ContainsSomeFilter(word, ignoreCase);
            }
        } else if ((flag & 8) != 0) {
            if (filter == null) {
                filter = new ContainsFilter(word, ignoreCase);
            }
        } else if ((flag & 0x100) != 0) {
            if (filter == null) {
                filter = new SimilarFilter(word, ignoreCase);
            }
        } else if ((flag & 0x200) != 0) {
            if (filter == null) {
                filter = new SoundFilter(word, ignoreCase);
            }
        } else if ((flag & 0x400) != 0) {
            if (filter == null) {
                filter = new WildcardFilter(word, ignoreCase);
            }
        } else if ((flag & 0x40) != 0 && filter == null) {
            filter = new RegexFilter(word, ignoreCase);
        }
        if (filter == null) {
            throw new WordnetError("Invalid filter flag(s): " + flag);
        }
        return filter;
    }

    protected List parseIntoPhrases(String sInputTerm) {
        if (sInputTerm == null) {
            return new ArrayList(0);
        }
        String sInput = sInputTerm.trim();
        if (sInput.length() < 1) {
            return new ArrayList(0);
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int nLen = sInput.length();
        boolean inQuote = false;
        StringBuilder sb = new StringBuilder(200);
        while (i < nLen) {
            char ch = sInput.charAt(i);
            if (ch == '\"') {
                if (inQuote) {
                    list.add(sb.toString());
                }
                inQuote = !inQuote;
                sb.setLength(0);
                ++i;
                continue;
            }
            if (ch == '\\') {
                if (++i >= nLen) break;
                ch = sInput.charAt(i);
                switch (ch) {
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
                ++i;
                continue;
            }
            if (ch == ' ') {
                if (inQuote) {
                    sb.append(ch);
                } else if (sb.length() > 0) {
                    list.add(sb.toString());
                    sb.setLength(0);
                }
                ++i;
                continue;
            }
            sb.append(ch);
            ++i;
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list;
    }
}

