/*
 * Decompiled with CFR 0.152.
 */
package rita.wordnet;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.IndexWordSet;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.PointerUtils;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.Word;
import net.didion.jwnl.data.list.PointerTargetNode;
import net.didion.jwnl.data.list.PointerTargetNodeList;
import net.didion.jwnl.data.list.PointerTargetTree;
import net.didion.jwnl.data.relationship.AsymmetricRelationship;
import net.didion.jwnl.data.relationship.RelationshipFinder;
import net.didion.jwnl.data.relationship.RelationshipList;
import net.didion.jwnl.dictionary.Dictionary;
import net.didion.jwnl.util.TypeCheckingList;
import processing.core.PApplet;
import rita.wordnet.RiZipReader;
import rita.wordnet.Wordnet;
import rita.wordnet.WordnetError;
import rita.wordnet.WordnetFilters;
import rita.wordnet.WordnetPos;
import rita.wordnet.WordnetUtil;

public class RiWordnet
implements Wordnet {
    private static final String VERSION = "034";
    public static final String NOUN = "n";
    public static final String VERB = "v";
    public static final String ADJ = "a";
    public static final String ADV = "r";
    public static final boolean DBUG = false;
    private static final String ROOT = "entity";
    public static String wordnetHome;
    public static String SLASH;
    public Dictionary jwnlDict;
    protected static RiZipReader zipReader;
    protected WordnetFilters filters;
    protected int maxCharsPerWord = 10;
    protected boolean ignoreCompoundWords = true;
    protected boolean ignoreUpperCaseWords = true;
    public static PApplet pApplet;

    static {
        SLASH = System.getProperty("file.separator");
        System.out.println("[INFO] RiTa.WordNet.version [034]");
    }

    public RiWordnet() {
        this(null, null);
    }

    public RiWordnet(PApplet pApplet) {
        this(pApplet, null);
    }

    public RiWordnet(PApplet pApplet, String wordnetInstallDir) {
        this(pApplet, wordnetInstallDir, RiWordnet.getDefaultConfFile());
    }

    private static String getDefaultConfFile() {
        Locale.setDefault(Locale.ENGLISH);
        return "file_properties.xml";
    }

    private RiWordnet(PApplet pApplet, String wordnetHome, String confFile) {
        RiWordnet.pApplet = pApplet;
        this.setWordnetHome(wordnetHome);
        if (!JWNL.isInitialized()) {
            try {
                this.initWordnet(confFile);
            }
            catch (Exception e) {
                throw new WordnetError("Unable to load Wordnet with $WORDNET_HOME=" + wordnetHome + " & CONF_FILE=" + confFile, (Throwable)e);
            }
        }
        if (this.jwnlDict == null) {
            this.jwnlDict = Dictionary.getInstance();
        }
        if (pApplet != null) {
            pApplet.registerDispose((Object)this);
            if (pApplet.frame != null) {
                pApplet.frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        RiWordnet.this.dispose();
                    }
                });
            }
        }
    }

    public static RiWordnet createRemote(Map params) {
        return new RiWordnet();
    }

    public Iterator iterator(String pos) {
        return this.getFilters().lemmaIterator(this.jwnlDict, this.convertPos(pos));
    }

    public String[] getAnagrams(String word, String posStr, int maxResults) {
        return this.filter(1, word, this.convertPos(posStr), maxResults);
    }

    public String[] getAnagrams(String word, String posStr) {
        return this.getAnagrams(word, posStr, Integer.MAX_VALUE);
    }

    public String[] getContains(String word, String posStr, int maxResults) {
        return this.filter(8, word, this.convertPos(posStr), maxResults);
    }

    public String[] getContains(String word, String posStr) {
        return this.getContains(word, posStr, Integer.MAX_VALUE);
    }

    public String[] getEndsWith(String word, String posStr, int maxResults) {
        return this.filter(16, word, this.convertPos(posStr), maxResults);
    }

    public String[] getEndsWith(String word, String posStr) {
        return this.getEndsWith(word, posStr, Integer.MAX_VALUE);
    }

    public String[] getStartsWith(String word, String posStr, int maxResults) {
        return this.filter(128, word, this.convertPos(posStr), maxResults);
    }

    public String[] getStartsWith(String word, String posStr) {
        return this.getStartsWith(word, posStr, Integer.MAX_VALUE);
    }

    public String[] getRegexMatch(String pattern, String posStr, int maxResults) {
        return this.filter(64, pattern, this.convertPos(posStr), maxResults);
    }

    public String[] getRegexMatch(String pattern, String posStr) {
        return this.getRegexMatch(pattern, posStr, Integer.MAX_VALUE);
    }

    public String[] getSoundsLike(String pattern, String posStr, int maxResults) {
        return this.filter(512, pattern, this.convertPos(posStr), maxResults);
    }

    public String[] getSoundsLike(String pattern, String posStr) {
        return this.getSoundsLike(pattern, posStr, Integer.MAX_VALUE);
    }

    public String[] getWildcardMatch(String pattern, String posStr, int maxResults) {
        return this.filter(1024, pattern, this.convertPos(posStr), maxResults);
    }

    public String[] getWildcardMatch(String pattern, String posStr) {
        return this.getWildcardMatch(pattern, posStr, Integer.MAX_VALUE);
    }

    public String[] filter(int filterFlag, String word, POS pos, int maxResults) {
        return RiWordnet.toStrArr(this.getFilters().filter(filterFlag, word, pos, maxResults));
    }

    public String[] filter(int filterFlag, String word, POS pos) {
        return this.filter(filterFlag, word, pos, Integer.MAX_VALUE);
    }

    public String[] orFilter(int[] filterFlags, String[] words, POS pos, int maxResults) {
        return RiWordnet.toStrArr(this.getFilters().orFilter(filterFlags, words, pos, maxResults));
    }

    private WordnetFilters getFilters() {
        if (this.filters == null) {
            this.filters = new WordnetFilters(this);
        }
        return this.filters;
    }

    public String[] orFilter(int[] filterFlag, String[] word, POS pos) {
        return this.orFilter(filterFlag, word, pos, Integer.MAX_VALUE);
    }

    private String[] andFilter(int[] filterFlags, String[] words, POS pos, int maxResults) {
        return RiWordnet.toStrArr(this.getFilters().andFilter(filterFlags, words, pos, maxResults));
    }

    private String[] andFilter(int[] filterFlag, String[] word, POS pos) {
        return this.andFilter(filterFlag, word, pos, Integer.MAX_VALUE);
    }

    public void dispose() {
        if (this.jwnlDict != null) {
            this.jwnlDict.close();
        }
        this.jwnlDict = null;
        if (zipReader != null) {
            zipReader.dispose();
        }
        zipReader = null;
    }

    public void setWordnetHome(String wordnetHome) {
        if (wordnetHome != null && !wordnetHome.endsWith("/") && !wordnetHome.endsWith("\\")) {
            wordnetHome = String.valueOf(wordnetHome) + SLASH;
        }
        RiWordnet.wordnetHome = wordnetHome;
        String home = wordnetHome != null ? wordnetHome : "jar:/rita/wordnet/WordNet3.1";
        System.out.println("[INFO] RiTa.Wordnet.home=" + home);
    }

    private List getSynsetList(int id) {
        Synset syns = this.getSynsetAtId(id);
        if (syns == null || syns.getWordsSize() < 1) {
            return null;
        }
        LinkedList l = new LinkedList();
        this.addLemmas(syns.getWords(), l);
        return l;
    }

    private Synset getSynsetAtId(int id) {
        POS pos = null;
        String idStr = Integer.toString(id);
        int posDigit = Integer.parseInt(idStr.substring(0, 1));
        long offset = Long.parseLong(idStr.substring(1));
        switch (posDigit) {
            case 9: {
                pos = POS.NOUN;
                break;
            }
            case 8: {
                pos = POS.VERB;
                break;
            }
            case 7: {
                pos = POS.ADJECTIVE;
                break;
            }
            case 6: {
                pos = POS.ADVERB;
            }
        }
        try {
            return this.jwnlDict.getSynsetAt(pos, offset);
        }
        catch (JWNLException e) {
            throw new WordnetError(e);
        }
    }

    public int[] getSenseIds(String word, String posStr) {
        POS pos = this.convertPos(posStr);
        IndexWord idw = this.lookupIndexWord(pos, (CharSequence)word);
        return this.getSenseIds(idw);
    }

    public int[] getSenseIds(IndexWord idw) {
        int[] result;
        block4: {
            result = null;
            int numSenses = idw.getSenseCount();
            if (idw != null && numSenses != 0) break block4;
            return null;
        }
        try {
            long[] offsets = idw.getSynsetOffsets();
            result = new int[offsets.length];
            int i = 0;
            while (i < result.length) {
                result[i] = this.toId(idw.getPOS(), offsets[i]);
                ++i;
            }
        }
        catch (Exception e) {
            throw new WordnetError(e);
        }
        return result;
    }

    private int toId(POS wnpos, long offset) {
        int posDigit = -1;
        if (wnpos == POS.NOUN) {
            posDigit = 9;
        } else if (wnpos == POS.VERB) {
            posDigit = 8;
        } else if (wnpos == POS.ADJECTIVE) {
            posDigit = 7;
        } else if (wnpos == POS.ADVERB) {
            posDigit = 6;
        } else {
            throw new WordnetError("Invalid POS type: " + wnpos);
        }
        return Integer.parseInt(String.valueOf(Integer.toString(posDigit)) + offset);
    }

    public String getGloss(String word, String pos) {
        Synset synset = this.getSynsetAtIndex(word, pos, 1);
        return this.getGloss(synset);
    }

    public String[] getAllGlosses(String word, String pos) {
        LinkedList<String> glosses = new LinkedList<String>();
        Synset[] synsets = this.allSynsets(word, pos);
        int i = 0;
        while (i < synsets.length) {
            String gloss = this.getGloss(synsets[i]);
            if (gloss != null) {
                glosses.add(gloss);
            }
            ++i;
        }
        return RiWordnet.toStrArr(glosses);
    }

    public String getGloss(int senseId) {
        Synset synset = this.getSynsetAtId(senseId);
        if (synset == null) {
            return null;
        }
        return this.getGloss(synset);
    }

    public String getDescription(int senseId) {
        String gloss = this.getGloss(senseId);
        return WordnetUtil.parseDescription(gloss);
    }

    private String getGloss(Synset synset) {
        if (synset == null) {
            return null;
        }
        return synset.getGloss();
    }

    public String getDescription(String word, String pos) {
        String gloss = this.getGloss(word, pos);
        return WordnetUtil.parseDescription(gloss);
    }

    public String[] getExamples(CharSequence word, CharSequence pos) {
        Synset synset = this.getSynsetAtIndex(word, pos, 1);
        List l = this.getExamples(synset);
        return RiWordnet.toStrArr(l);
    }

    public String getAnyExample(CharSequence word, CharSequence pos) {
        String[] all = this.getAllExamples(word, pos);
        int rand = (int)(Math.random() * (double)all.length);
        return all[rand];
    }

    public String[] getExamples(int senseId) {
        Synset synset = this.getSynsetAtId(senseId);
        if (synset == null) {
            return null;
        }
        return RiWordnet.toStrArr(this.getExamples(synset));
    }

    public String[] getAllExamples(CharSequence word, CharSequence pos) {
        Synset[] syns = this.allSynsets(word, pos);
        if (syns == null || syns.length < 1) {
            return null;
        }
        LinkedList<String> l = new LinkedList<String>();
        int i = 0;
        while (i < syns.length) {
            if (syns[i] != null) {
                int j = 0;
                while (j < syns.length) {
                    List examples = this.getExamples(syns[i]);
                    if (examples != null) {
                        Iterator k = examples.iterator();
                        while (k.hasNext()) {
                            String example = (String)k.next();
                            if (example.indexOf(word.toString()) < 0 || l.contains(example)) continue;
                            l.add(example);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        l.remove(word);
        return RiWordnet.toStrArr(l);
    }

    private List getExamples(Synset synset) {
        String gloss = this.getGloss(synset);
        return WordnetUtil.parseExamples(gloss);
    }

    public String[] getAllSynonyms(int senseId, int maxResults) {
        String[] result = null;
        HashSet set = new HashSet();
        result = this.getSynset(senseId);
        this.addSynsetsToSet(result, set);
        result = this.getHyponymTree(senseId);
        this.addSynsetsToSet(result, set);
        result = this.getSimilar(senseId);
        this.addSynsetsToSet(result, set);
        result = this.getCoordinates(senseId);
        this.addSynsetsToSet(result, set);
        result = this.getAlsoSees(senseId);
        this.addSynsetsToSet(result, set);
        return this.setToStrings(set, maxResults, true);
    }

    public String[] getAllSynonyms(int id) {
        return this.getAllSynonyms(id, Integer.MAX_VALUE);
    }

    public String[] getSynonyms(String word, String posStr, int maxResults) {
        String[] result = null;
        HashSet set = new HashSet();
        result = this.getSynset(word, posStr, false);
        this.addSynsetsToSet(result, set);
        result = this.getHypernyms(word, posStr);
        this.addSynsetsToSet(result, set);
        result = this.getSimilar(word, posStr);
        this.addSynsetsToSet(result, set);
        result = this.getAlsoSees(word, posStr);
        this.addSynsetsToSet(result, set);
        result = this.getCoordinates(word, posStr);
        this.addSynsetsToSet(result, set);
        return this.setToStrings(set, maxResults, true);
    }

    public String[] getSynonyms(String word, String posStr) {
        return this.getSynonyms(word, posStr, Integer.MAX_VALUE);
    }

    public String[] getAllSynonyms(String word, String posStr, int maxResults) {
        boolean dbug = false;
        String[] result = null;
        HashSet set = new HashSet();
        result = this.getAllSynsets(word, posStr);
        this.addSynsetsToSet(result, set);
        result = this.getAllHyponyms(word, posStr);
        this.addSynsetsToSet(result, set);
        result = this.getAllSimilar(word, posStr);
        this.addSynsetsToSet(result, set);
        result = this.getAllAlsoSees(word, posStr);
        this.addSynsetsToSet(result, set);
        result = this.getAllCoordinates(word, posStr);
        this.addSynsetsToSet(result, set);
        return this.setToStrings(set, maxResults, true);
    }

    public String[] getAllSynonyms(String word, String posStr) {
        return this.getAllSynonyms(word, posStr, Integer.MAX_VALUE);
    }

    private void addSynsetsToSet(String[] s, Set set) {
        this.addSynsetsToSet(s, set, Integer.MAX_VALUE);
    }

    private void addSynsetsToSet(String[] s, Set set, int maxResults) {
        if (s == null || s.length < 0) {
            return;
        }
        int i = 0;
        while (i < s.length) {
            if (s[i].indexOf(":") > 0) {
                String[] t = s[i].split(":");
                int u = 0;
                while (u < t.length) {
                    set.add(t[u]);
                    if (set.size() >= maxResults) {
                        return;
                    }
                    ++u;
                }
            } else {
                set.add(s[i]);
                if (set.size() >= maxResults) {
                    return;
                }
            }
            ++i;
        }
    }

    private String[] setToStrings(Set set, int maxSize, boolean shuffle) {
        if (set == null || set.size() == 0) {
            return null;
        }
        ArrayList result = new ArrayList(set.size());
        result.addAll(set);
        Collections.shuffle(result);
        int size = Math.min(maxSize, set.size());
        int idx = 0;
        String[] ret = new String[size];
        Iterator i = result.iterator();
        while (i.hasNext()) {
            ret[idx++] = (String)i.next();
            if (idx == size) break;
        }
        return ret;
    }

    public String[] getCommonParents(String word1, String word2, String pos) {
        List result = this.getCommonParentList(word1, word2, pos);
        return RiWordnet.toStrArr(result);
    }

    public Synset getCommonParent(int id1, int id2) throws JWNLException {
        Synset syn1 = this.getSynsetAtId(id1);
        if (syn1 == null) {
            return null;
        }
        Synset syn2 = this.getSynsetAtId(id2);
        if (syn2 == null) {
            return null;
        }
        RelationshipList list = RelationshipFinder.getInstance().findRelationships(syn1, syn2, PointerType.HYPERNYM);
        AsymmetricRelationship ar = (AsymmetricRelationship)list.get(0);
        PointerTargetNodeList nl = ar.getNodeList();
        PointerTargetNode ptn = (PointerTargetNode)nl.get(ar.getCommonParentIndex());
        return ptn.getSynset();
    }

    private List getCommonParentList(String word1, String word2, String pos) {
        IndexWord iw2;
        IndexWord iw1;
        Synset syn;
        block6: {
            POS wnpos;
            block5: {
                syn = null;
                try {
                    wnpos = this.convertPos(pos);
                    iw1 = this.lookupIndexWord(wnpos, (CharSequence)word1);
                    if (iw1 != null) break block5;
                    return null;
                }
                catch (JWNLException e) {
                    throw new WordnetError((Object)this, (Throwable)e);
                }
            }
            iw2 = this.lookupIndexWord(wnpos, (CharSequence)word2);
            if (iw2 != null) break block6;
            return null;
        }
        syn = this.getCommonParent(iw1, iw2);
        if (syn == null) {
            return null;
        }
        ArrayList l = new ArrayList();
        this.addLemmas(syn.getWords(), l);
        return l == null || l.size() < 1 ? null : l;
    }

    private Synset getCommonParent(IndexWord start, IndexWord end) throws JWNLException {
        if (start == null || end == null) {
            return null;
        }
        TypeCheckingList list = null;
        try {
            list = RelationshipFinder.getInstance().findRelationships(start.getSense(1), end.getSense(1), PointerType.HYPERNYM);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (list == null) {
            return null;
        }
        AsymmetricRelationship ar = (AsymmetricRelationship)list.get(0);
        PointerTargetNodeList nl = ar.getNodeList();
        PointerTargetNode ptn = (PointerTargetNode)nl.get(ar.getCommonParentIndex());
        return ptn.getSynset();
    }

    public String[] getSynset(String word, String pos) {
        return this.getSynset(word, pos, false);
    }

    public String[] getSynset(String word, String pos, boolean includeOriginal) {
        Synset syns = this.getSynsetAtIndex(word, pos, 1);
        if (syns == null || syns.getWordsSize() < 1) {
            return null;
        }
        LinkedList l = new LinkedList();
        Word[] words = syns.getWords();
        this.addLemmas(words, l);
        if (!includeOriginal) {
            l.remove(word);
        }
        return RiWordnet.toStrArr(l);
    }

    public String[] getSynset(int id) {
        return RiWordnet.toStrArr(this.getSynsetList(id));
    }

    public String[] getAllSynsets(String word, String posStr) {
        LinkedList result;
        IndexWord idw;
        block6: {
            POS pos = this.convertPos(posStr);
            idw = null;
            result = null;
            idw = this.lookupIndexWord(pos, (CharSequence)word);
            if (idw != null && idw.getSenseCount() >= 1) break block6;
            return null;
        }
        try {
            result = new LinkedList();
            int i = 1;
            while (i <= idw.getSenseCount()) {
                List syns = this.getSynsetAtIndex(idw, i);
                if (syns != null && syns.size() >= 1) {
                    Iterator j = syns.iterator();
                    while (j.hasNext()) {
                        String lemma = (String)j.next();
                        this.addLemma(lemma, result);
                    }
                }
                ++i;
            }
            result.remove(word);
            return RiWordnet.toStrArr(result);
        }
        catch (JWNLException e) {
            throw new WordnetError(e);
        }
    }

    private List getSynsetAtIndex(IndexWord word, int index) throws JWNLException {
        if (index < 1) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        if (word == null || word.getSenseCount() < 1) {
            return null;
        }
        ArrayList l = new ArrayList();
        this.addLemmas(word.getSense(index).getWords(), l);
        return l;
    }

    private Synset[] allSynsets(CharSequence word, CharSequence posStr) {
        POS pos = this.convertPos(posStr);
        IndexWord idw = this.lookupIndexWord(pos, word);
        if (idw == null) {
            return null;
        }
        int senseCount = idw.getSenseCount();
        if (senseCount < 1) {
            return null;
        }
        Synset[] syns = new Synset[senseCount];
        int i = 0;
        while (i < syns.length) {
            try {
                syns[i] = idw.getSense(i + 1);
                if (syns[i] == null) {
                    System.err.println("[WARN] Wordnet returned null Synset for: " + word + "/" + pos);
                }
            }
            catch (JWNLException e) {
                throw new WordnetError(e);
            }
            ++i;
        }
        return syns;
    }

    private Synset getSynsetAtIndex(CharSequence word, CharSequence posStr, int i) {
        if (i < 1) {
            throw new IllegalArgumentException("Invalid index: " + i);
        }
        POS pos = this.convertPos(posStr);
        IndexWord idw = this.lookupIndexWord(pos, word);
        if (idw == null || idw.getSenseCount() < i) {
            return null;
        }
        try {
            return idw.getSense(i);
        }
        catch (JWNLException e) {
            throw new WordnetError(e);
        }
    }

    public int getSenseCount(String word, String pos) {
        int senses = -1;
        try {
            IndexWord iw = this.lookupIndexWord(pos, word);
            if (iw != null) {
                senses = iw.getSenseCount();
            }
        }
        catch (WordnetError e) {
            System.err.println("[WARN] " + e.getMessage());
        }
        return senses;
    }

    public String[] getAntonyms(String word, String pos) {
        return this.getPointerTargetsAtIndex(word, pos, PointerType.ANTONYM, 1);
    }

    public String[] getAntonyms(int id) {
        return this.getPointerTargetsAtId(id, PointerType.ANTONYM);
    }

    public String[] getAllAntonyms(String word, String pos) {
        return this.getAllPointerTargets(word, pos, PointerType.ANTONYM);
    }

    public String[] getHypernyms(String word, String posStr) {
        Synset synset = this.getSynsetAtIndex(word, posStr, 1);
        PointerTargetNodeList ptnl = null;
        try {
            ptnl = PointerUtils.getInstance().getDirectHypernyms(synset);
        }
        catch (NullPointerException e) {
            System.err.println("[WARN] JWNL Error: " + word + "/" + posStr);
        }
        catch (JWNLException e) {
            throw new WordnetError(e);
        }
        return this.ptnlToStrings(word, ptnl);
    }

    public String[] getHypernyms(int id) {
        Synset synset = this.getSynsetAtId(id);
        PointerTargetNodeList ptnl = null;
        try {
            ptnl = PointerUtils.getInstance().getDirectHypernyms(synset);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (JWNLException e) {
            throw new WordnetError(e);
        }
        return this.ptnlToStrings(null, ptnl);
    }

    private void getHypernyms(Synset syn, Collection l) throws JWNLException {
        PointerTargetNodeList ptnl = null;
        try {
            ptnl = PointerUtils.getInstance().getDirectHypernyms(syn);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.getLemmaSet(ptnl, l);
    }

    public String[] getAllHypernyms(String word, String posStr) {
        try {
            IndexWord idw = this.lookupIndexWord(this.convertPos(posStr), (CharSequence)word);
            return RiWordnet.toStrArr(this.getAllHypernyms(idw));
        }
        catch (JWNLException e) {
            throw new WordnetError((Object)this, (Throwable)e);
        }
    }

    public String[] getHypernymTree(int id) throws JWNLException {
        Synset synset = this.getSynsetAtId(id);
        if (synset == null) {
            return new String[]{ROOT};
        }
        List l = this.getHypernymTree(synset);
        return RiWordnet.toStrArr(l);
    }

    private List getAllHypernyms(IndexWord idw) throws JWNLException {
        if (idw == null) {
            return null;
        }
        Synset[] synsets = idw.getSenses();
        if (synsets == null || synsets.length <= 0) {
            return null;
        }
        int i = 0;
        LinkedList result = new LinkedList();
        while (i < synsets.length) {
            this.getHypernyms(synsets[i], result);
            ++i;
        }
        return result == null || result.size() < 1 ? null : result;
    }

    private List getHypernymTree(Synset synset) throws JWNLException {
        if (synset == null) {
            return null;
        }
        PointerTargetTree ptt = null;
        try {
            ptt = PointerUtils.getInstance().getHypernymTree(synset);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (ptt == null) {
            return null;
        }
        List pointerTargetNodeLists = ptt.toList();
        int count = 0;
        ArrayList<String> l = new ArrayList<String>();
        Iterator i = pointerTargetNodeLists.iterator();
        while (i.hasNext()) {
            PointerTargetNodeList ptnl = (PointerTargetNodeList)i.next();
            List strs = this.getLemmaStrings(ptnl, ":", false);
            Iterator it = strs.iterator();
            while (it.hasNext()) {
                String lemma = (String)it.next();
                if (lemma.length() <= 0 || l.contains(lemma)) continue;
                l.add(lemma);
            }
            ++count;
        }
        if (l.size() == 1) {
            l.remove(0);
        }
        return l == null || l.size() < 1 ? null : l;
    }

    public String[] getHyponyms(String word, String posStr) {
        Synset synset = this.getSynsetAtIndex(word, posStr, 1);
        PointerTargetNodeList ptnl = null;
        try {
            PointerUtils pu = PointerUtils.getInstance();
            ptnl = pu.getDirectHyponyms(synset);
            if (ptnl == null) {
                throw new RuntimeException("JWNL ERR: " + word + "/" + posStr);
            }
        }
        catch (NullPointerException e) {
            throw new RuntimeException("JWNL BUG: " + word + "/" + posStr);
        }
        catch (JWNLException e) {
            throw new WordnetError(e);
        }
        return this.ptnlToStrings(word, ptnl);
    }

    public String[] getHyponyms(int id) {
        Synset synset = this.getSynsetAtId(id);
        PointerTargetNodeList ptnl = null;
        try {
            ptnl = PointerUtils.getInstance().getDirectHyponyms(synset);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (JWNLException e) {
            throw new WordnetError(e);
        }
        return this.ptnlToStrings(null, ptnl);
    }

    private void getHyponyms(Synset syn, Collection l) throws JWNLException {
        PointerTargetNodeList ptnl = null;
        try {
            PointerUtils pu = PointerUtils.getInstance();
            ptnl = pu.getDirectHyponyms(syn);
        }
        catch (NullPointerException e) {
            System.out.println("JWNL BUG: " + e);
            return;
        }
        this.getLemmaSet(ptnl, l);
    }

    public String[] getAllHyponyms(String word, String posStr) {
        IndexWord idw = this.lookupIndexWord(this.convertPos(posStr), (CharSequence)word);
        List l = this.getAllHyponyms(idw);
        if (l == null) {
            return null;
        }
        l.remove(word);
        return RiWordnet.toStrArr(l);
    }

    private List getAllHyponyms(IndexWord idw) {
        if (idw == null) {
            return null;
        }
        Synset[] synsets = null;
        try {
            synsets = idw.getSenses();
        }
        catch (JWNLException e) {
            throw new WordnetError(e);
        }
        if (synsets == null || synsets.length <= 0) {
            return null;
        }
        LinkedList l = new LinkedList();
        int i = 0;
        while (i < synsets.length) {
            try {
                this.getHyponyms(synsets[i], l);
            }
            catch (JWNLException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return l == null || l.size() < 1 ? null : l;
    }

    public String[] getHyponymTree(int id) {
        Synset synset = this.getSynsetAtId(id);
        if (synset == null) {
            return null;
        }
        List l = null;
        try {
            l = this.getHyponymTree(synset);
        }
        catch (JWNLException e) {
            e.printStackTrace();
        }
        return RiWordnet.toStrArr(l);
    }

    private List getHyponymTree(Synset synset) throws JWNLException {
        if (synset == null) {
            return null;
        }
        PointerTargetTree ptt = null;
        try {
            ptt = PointerUtils.getInstance().getHyponymTree(synset);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (ptt == null) {
            return null;
        }
        List pointerTargetNodeLists = ptt.toList();
        ArrayList<String> l = new ArrayList<String>();
        Iterator i = pointerTargetNodeLists.iterator();
        while (i.hasNext()) {
            PointerTargetNodeList ptnl = (PointerTargetNodeList)i.next();
            List tmp = this.getLemmaStrings(ptnl, ":", true);
            Iterator it = tmp.iterator();
            while (it.hasNext()) {
                String syn = (String)it.next();
                if ((syn = RiWordnet.trimFirstandLastChars(syn)).length() < 2 || l.contains(syn)) continue;
                l.add(syn);
            }
        }
        HashSet syns = new HashSet();
        this.addLemmas(synset.getWords(), syns);
        Iterator iter = l.iterator();
        block4: while (iter.hasNext()) {
            String syn = ":" + (String)iter.next() + ":";
            Iterator j = syns.iterator();
            while (j.hasNext()) {
                String lemma = ":" + j.next() + ":";
                if (syn.indexOf(lemma) <= -1) continue;
                iter.remove();
                continue block4;
            }
        }
        return l;
    }

    public boolean isAdjective(String word) {
        return this.getPosStr(word).indexOf(Character.toString('a')) > -1;
    }

    public boolean isAdverb(String word) {
        return this.getPosStr(word).indexOf(Character.toString('r')) > -1;
    }

    public boolean isVerb(String word) {
        return this.getPosStr(word).indexOf(Character.toString('v')) > -1;
    }

    public boolean isNoun(String word) {
        return this.getPosStr(word).indexOf(Character.toString('n')) > -1;
    }

    public String[] getStems(String query, CharSequence pos) {
        List tmp = this.getStemList(query, pos);
        return RiWordnet.toStrArr(tmp);
    }

    public boolean isStem(String word, CharSequence pos) {
        String[] stems = this.getStems(word, pos);
        if (stems == null) {
            return false;
        }
        int i = 0;
        while (i < stems.length) {
            if (word.equals(stems[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private List getStemList(String query, CharSequence pos) {
        try {
            return this.jwnlDict.getMorphologicalProcessor().lookupAllBaseForms(this.convertPos(pos), query);
        }
        catch (JWNLException e) {
            throw new WordnetError((Object)this, (Throwable)e);
        }
    }

    public boolean exists(String word) {
        IndexWordSet iws;
        IndexWord[] iw;
        block5: {
            if (word.indexOf(32) > -1) {
                return false;
            }
            iw = null;
            if (this.jwnlDict == null) {
                System.err.println("NULL DICT");
                System.exit(1);
            }
            if ((iws = this.jwnlDict.lookupAllIndexWords(word)) != null && iws.size() >= 1) break block5;
            return false;
        }
        try {
            iw = iws.getIndexWordArray();
        }
        catch (JWNLException e) {
            System.err.println("[WARN] " + e.getMessage());
        }
        return iw != null && iw.length > 0;
    }

    public void removeNonExistent(Collection words) {
        Iterator i = words.iterator();
        while (i.hasNext()) {
            String word = (String)i.next();
            if (this.exists(word)) continue;
            i.remove();
        }
    }

    private IndexWord lookupIndexWord(String pos, String word) {
        return this.lookupIndexWord(this.convertPos(pos), (CharSequence)word);
    }

    private POS convertPos(String pos) {
        POS wnPos = WordnetPos.getPos(pos);
        if (wnPos == null) {
            throw new WordnetError((Object)this, "Invalid Pos-String: '" + pos + "'");
        }
        return wnPos;
    }

    public IndexWord lookupIndexWord(POS pos, CharSequence cs) {
        if (cs == null) {
            return null;
        }
        String word = cs.toString().replace('-', '_');
        IndexWord iword = null;
        try {
            iword = this.jwnlDict.lookupIndexWord(pos, word);
        }
        catch (JWNLException jWNLException) {
            // empty catch block
        }
        return iword;
    }

    private String toLemmaString(Word[] words, String delim, boolean addStartAndEndDelims) {
        if (words == null || words.length == 0) {
            return null;
        }
        ArrayList dest = new ArrayList();
        this.addLemmas(words, dest);
        String result = WordnetUtil.join(dest, delim);
        if (addStartAndEndDelims) {
            result = String.valueOf(delim) + result + delim;
        }
        return result;
    }

    private void addLemmas(Word[] words, Collection dest) {
        if (words == null || words.length == 0) {
            return;
        }
        int k = 0;
        while (k < words.length) {
            this.addLemma(words[k], dest);
            ++k;
        }
    }

    private void addLemma(Word word, Collection dest) {
        this.addLemma(word.getLemma(), dest);
    }

    private void addLemma(String lemma, Collection dest) {
        if (this.ignoreCompoundWords && RiWordnet.isCompound(lemma)) {
            return;
        }
        if (this.ignoreUpperCaseWords && WordnetUtil.startsWithUppercase(lemma)) {
            return;
        }
        if (!dest.contains(lemma = this.cleanLemma(lemma))) {
            dest.add(lemma);
        }
    }

    private void getLemmaSet(PointerTargetNodeList source, Collection dest) {
        if (source == null) {
            return;
        }
        Iterator i = source.iterator();
        while (i.hasNext()) {
            PointerTargetNode targetNode = (PointerTargetNode)i.next();
            if (!targetNode.isLexical()) {
                Synset syn = targetNode.getSynset();
                if (syn == null) continue;
                this.addLemmas(syn.getWords(), dest);
                continue;
            }
            this.addLemma(targetNode.getWord(), dest);
        }
    }

    private List getLemmaStrings(PointerTargetNodeList source, String delim, boolean addStartAndEndDelims) {
        ArrayList<String> l = new ArrayList<String>();
        Iterator i = source.iterator();
        while (i.hasNext()) {
            PointerTargetNode targetNode = (PointerTargetNode)i.next();
            if (!targetNode.isLexical()) {
                Synset syn = targetNode.getSynset();
                if (syn == null) continue;
                String s = this.toLemmaString(syn.getWords(), delim, addStartAndEndDelims);
                l.add(s);
                continue;
            }
            ArrayList dest = new ArrayList();
            this.addLemma(targetNode.getWord(), dest);
            System.err.println("ILLEGAL CALL TO TARGET: " + targetNode.getWord());
        }
        return l == null || l.size() < 1 ? null : l;
    }

    private static String trimFirstandLastChars(String s) {
        if (s.length() < 2) {
            throw new IllegalArgumentException("Invalid length String: '" + s + "'");
        }
        return s.substring(1, s.length() - 1);
    }

    private String cleanLemma(String lemma) {
        if (lemma.endsWith(")")) {
            lemma = lemma.substring(0, lemma.length() - 3);
        }
        lemma = WordnetUtil.replace(lemma, '_', '-');
        return lemma;
    }

    public String[] getPos(String word) {
        IndexWord[] all = this.getIndexWords(word);
        if (all == null) {
            return null;
        }
        String[] pos = new String[all.length];
        int i = 0;
        while (i < all.length) {
            pos[i] = all[i].getPOS().getKey();
            ++i;
        }
        return pos;
    }

    public String getPos(int id) {
        Synset synsets = this.getSynsetAtId(id);
        if (synsets == null) {
            return null;
        }
        return synsets.getPOS().getKey();
    }

    public String getPosStr(String word) {
        String pos = "";
        IndexWord[] all = this.getIndexWords(word);
        if (all == null) {
            return pos;
        }
        int i = 0;
        while (i < all.length) {
            pos = String.valueOf(pos) + all[i].getPOS().getKey();
            ++i;
        }
        return pos;
    }

    public String getBestPos(String word) {
        IndexWord[] all = this.getIndexWords(word);
        if (all == null || all.length < 1) {
            return null;
        }
        POS p = all[0].getPOS();
        if (p == POS.NOUN) {
            return NOUN;
        }
        if (p == POS.VERB) {
            return VERB;
        }
        if (p == POS.ADVERB) {
            return ADV;
        }
        if (p == POS.ADJECTIVE) {
            return ADJ;
        }
        throw new WordnetError("no pos for word: " + word);
    }

    private IndexWord[] getIndexWords(CharSequence word) {
        ArrayList<ComparableIndexWord> list = new ArrayList<ComparableIndexWord>();
        Iterator itr = POS.getAllPOS().iterator();
        while (itr.hasNext()) {
            IndexWord current = this.lookupIndexWord((POS)itr.next(), (CharSequence)word.toString());
            if (current == null) continue;
            int polysemy = current.getSenseCount();
            list.add(new ComparableIndexWord(current, polysemy));
        }
        int idx = 0;
        Collections.sort(list);
        IndexWord[] iws = new IndexWord[list.size()];
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ComparableIndexWord ciw = (ComparableIndexWord)i.next();
            iws[idx++] = ciw.iw;
        }
        return iws;
    }

    private void initWordnet(String confFile) throws JWNLException {
        InputStream is = WordnetUtil.getResourceStream(this.getClass(), confFile);
        try {
            JWNL.initialize(is);
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            throw e;
        }
    }

    public static String[] toStrArr(List l) {
        if (l == null || l.size() == 0) {
            return null;
        }
        return l.toArray(new String[l.size()]);
    }

    String[] ptnlToStrings(String query, PointerTargetNodeList ptnl) {
        if (ptnl == null || ptnl.size() == 0) {
            return null;
        }
        LinkedList l = new LinkedList();
        this.getLemmaSet(ptnl, l);
        if (query != null) {
            l.remove(query);
        }
        return RiWordnet.toStrArr(l);
    }

    public String getRandomExample(CharSequence pos) {
        return this.getRandomExamples(pos, 1)[0];
    }

    public String[] getRandomExamples(CharSequence pos, int numExamples) {
        int idx = 0;
        String[] result = new String[numExamples];
        while (true) {
            try {
                while (true) {
                    IndexWord iw = null;
                    while (iw == null || !this.ignoreCompoundWords && WordnetUtil.contains(iw.getLemma(), " ")) {
                        iw = this.jwnlDict.getRandomIndexWord(this.convertPos(pos));
                    }
                    Synset syn = iw.getSenses()[0];
                    List l = this.getExamples(syn);
                    if (l == null || l.size() < 1) continue;
                    Iterator i = l.iterator();
                    while (i.hasNext()) {
                        String example = (String)i.next();
                        if (example == null) continue;
                        result[idx++] = example;
                        break;
                    }
                    if (idx == result.length) break;
                }
            }
            catch (JWNLException e) {
                System.err.println("WARN] Unexpected Exception: " + e.getMessage());
                continue;
            }
            break;
        }
        return result;
    }

    public String[] getRandomWords(CharSequence pos, int count) {
        String[] result = new String[count];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getRandomWord(pos, true, this.maxCharsPerWord);
            ++i;
        }
        return result;
    }

    public String getRandomWord(CharSequence pos) {
        return this.getRandomWord(pos, true, this.maxCharsPerWord);
    }

    public String getRandomWord(CharSequence pos, boolean stemsOnly, int maxChars) {
        IndexWord iw = null;
        POS wnPos = this.convertPos(pos);
        while (true) {
            try {
                iw = this.jwnlDict.getRandomIndexWord(wnPos);
            }
            catch (JWNLRuntimeException e) {
                continue;
            }
            catch (JWNLException e) {
                throw new WordnetError(e);
            }
            String word = iw.getLemma();
            if (!(this.ignoreCompoundWords && RiWordnet.isCompound(word) || word.length() > maxChars || stemsOnly && !this.isStem(word, pos))) break;
        }
        return iw.getLemma();
    }

    static boolean isCompound(String word) {
        return word.indexOf(32) > 0 || word.indexOf(45) > 0 || word.indexOf(95) > 0;
    }

    public Dictionary getDictionary() {
        return this.jwnlDict;
    }

    public void printHyponymTree(int senseId) {
        try {
            this.dumpHyponymTree(System.out, this.getSynsetAtId(senseId));
        }
        catch (JWNLException e) {
            throw new WordnetError(e);
        }
    }

    void dumpHyponymTree(String word, String pos) throws JWNLException {
        this.dumpHyponymTree(System.err, word, pos);
    }

    public void dumpHyponymTree(PrintStream ps, String word, String pos) throws JWNLException {
        IndexWord iw = this.lookupIndexWord(pos, word);
        Synset syn = iw.getSense(1);
        this.dumpHyponymTree(ps, syn);
    }

    void dumpHyponymTree(PrintStream ps, Synset syn) throws JWNLException {
        PointerTargetTree hyponyms = null;
        try {
            hyponyms = PointerUtils.getInstance().getHyponymTree(syn);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (hyponyms == null) {
            return;
        }
        HashSet syns = new HashSet();
        this.addLemmas(syn.getWords(), syns);
        ps.println("\nHyponyms of synset" + syns + ":\n-------------------------------------------");
        hyponyms.print(ps);
        ps.println();
    }

    public void printHypernymTree(int senseId) {
        try {
            Synset s = this.getSynsetAtId(senseId);
            this.dumpHypernymTree(System.out, s);
        }
        catch (JWNLException e) {
            throw new WordnetError(e);
        }
    }

    void printHypernymTree(String word, String pos) throws JWNLException {
        this.dumpHypernymTree(System.err, word, pos);
    }

    public void dumpHypernymTree(PrintStream ps, String word, String pos) throws JWNLException {
        IndexWord iw = this.lookupIndexWord(pos, word);
        Synset syn = iw.getSense(1);
        this.dumpHypernymTree(ps, syn);
    }

    void dumpHypernymTree(PrintStream ps, Synset syn) throws JWNLException {
        PointerTargetTree hypernyms = null;
        try {
            hypernyms = PointerUtils.getInstance().getHypernymTree(syn);
        }
        catch (StackOverflowError e) {
            PointerUtils.getInstance().setOverflowError(true);
            hypernyms = PointerUtils.getInstance().getHypernymTree(syn);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (hypernyms == null) {
            return;
        }
        HashSet syns = new HashSet();
        this.addLemmas(syn.getWords(), syns);
        ps.println("\nHypernyms of synset" + syns + ":\n-------------------------------------------");
        hypernyms.print(ps);
        ps.println();
    }

    public float getDistance(String lemma1, String lemma2, String pos) {
        float smallestD;
        block9: {
            if (lemma1 == null || lemma1.contains(" ")) {
                return -1.0f;
            }
            if (lemma2 == null || lemma2.contains(" ")) {
                return -1.0f;
            }
            float d = 1.0f;
            smallestD = 1.0f;
            POS p = this.convertPos(pos);
            if (lemma1.equals(lemma2)) {
                smallestD = 0.0f;
            } else {
                try {
                    IndexWordSet WORDSET1 = this.jwnlDict.lookupAllIndexWords(lemma1);
                    IndexWordSet WORDSET2 = this.jwnlDict.lookupAllIndexWords(lemma2);
                    if (!WORDSET1.isValidPOS(p) || !WORDSET2.isValidPOS(p)) break block9;
                    IndexWord WORD1 = WORDSET1.getIndexWord(p);
                    IndexWord WORD2 = WORDSET2.getIndexWord(p);
                    try {
                        d = this.getWordDistance(WORD1, WORD2);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (d < smallestD) {
                        smallestD = d;
                    }
                }
                catch (JWNLException e) {
                    System.err.println("[WARN] Error obtaining distance: " + e);
                    return 1.0f;
                }
            }
        }
        return smallestD;
    }

    private float getWordDistance(IndexWord start, IndexWord end) throws JWNLException, NullPointerException {
        float distance = 1.0f;
        int senseCount1 = start.getSenseCount();
        int senseCount2 = end.getSenseCount();
        int i = 1;
        while (i <= senseCount1) {
            int j = 1;
            while (j <= senseCount2) {
                block7: {
                    RelationshipList relList;
                    try {
                        relList = RelationshipFinder.getInstance().findRelationships(start.getSense(i), end.getSense(j), PointerType.HYPERNYM);
                    }
                    catch (Exception e) {
                        break block7;
                    }
                    Iterator relListItr = relList.iterator();
                    while (relListItr.hasNext()) {
                        AsymmetricRelationship rel = (AsymmetricRelationship)relListItr.next();
                        int cpIndex = rel.getCommonParentIndex();
                        int relLength = rel.getDepth();
                        int depthCpLeaf = Math.max(relLength - cpIndex, cpIndex);
                        PointerTargetNode cpNode = (PointerTargetNode)rel.getNodeList().get(cpIndex);
                        Synset cpSynset = cpNode.getSynset();
                        List cpHypListList = PointerUtils.getInstance().getHypernymTree(cpSynset).toList();
                        int depthRootCp = -1;
                        Iterator cpHypListListItr = cpHypListList.iterator();
                        while (cpHypListListItr.hasNext()) {
                            int depth = ((List)cpHypListListItr.next()).size();
                            if (depthRootCp == -1) {
                                depthRootCp = depth;
                                continue;
                            }
                            if (depth >= depthRootCp) continue;
                            depthRootCp = depth;
                        }
                        float newDistance = (float)depthCpLeaf / (float)(depthRootCp + depthCpLeaf);
                        if (!(newDistance < distance)) continue;
                        distance = newDistance;
                    }
                }
                ++j;
            }
            ++i;
        }
        return distance;
    }

    public String[] getMeronyms(String query, String pos) {
        Synset synset;
        block5: {
            try {
                synset = this.getSynsetAtIndex(query, pos, 1);
                if (synset != null) break block5;
                return null;
            }
            catch (JWNLException e) {
                throw new WordnetError((Object)this, (Throwable)e);
            }
        }
        PointerTargetNodeList ptnl = null;
        try {
            ptnl = PointerUtils.getInstance().getMeronyms(synset);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return this.ptnlToStrings(query, ptnl);
    }

    public String[] getMeronyms(int id) {
        Synset synset;
        block5: {
            try {
                synset = this.getSynsetAtId(id);
                if (synset != null) break block5;
                return null;
            }
            catch (JWNLException e) {
                throw new WordnetError((Object)this, (Throwable)e);
            }
        }
        PointerTargetNodeList ptnl = null;
        try {
            ptnl = PointerUtils.getInstance().getMeronyms(synset);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return this.ptnlToStrings(null, ptnl);
    }

    public String[] getAllMeronyms(String query, String pos) {
        Synset[] synsets;
        block7: {
            synsets = this.allSynsets(query, pos);
            if (synsets != null) break block7;
            return null;
        }
        try {
            LinkedList l = new LinkedList();
            int i = 0;
            while (i < synsets.length) {
                if (synsets[i] != null) {
                    PointerTargetNodeList ptnl = null;
                    try {
                        ptnl = PointerUtils.getInstance().getMeronyms(synsets[i]);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    this.getLemmaSet(ptnl, l);
                }
                ++i;
            }
            l.remove(query);
            return RiWordnet.toStrArr(l);
        }
        catch (JWNLException e) {
            throw new WordnetError((Object)this, (Throwable)e);
        }
    }

    public String[] getHolonyms(String query, String pos) {
        Synset synset2;
        PointerTargetNodeList ptnl;
        block4: {
            ptnl = null;
            synset2 = this.getSynsetAtIndex(query, pos, 1);
            if (synset2 != null) break block4;
            return null;
        }
        try {
            ptnl = PointerUtils.getInstance().getHolonyms(synset2);
        }
        catch (NullPointerException synset2) {
        }
        catch (JWNLException e) {
            throw new WordnetError((Object)this, (Throwable)e);
        }
        return this.ptnlToStrings(query, ptnl);
    }

    public String[] getHolonyms(int id) {
        Synset synset2;
        PointerTargetNodeList ptnl;
        block4: {
            ptnl = null;
            synset2 = this.getSynsetAtId(id);
            if (synset2 != null) break block4;
            return null;
        }
        try {
            ptnl = PointerUtils.getInstance().getHolonyms(synset2);
        }
        catch (NullPointerException synset2) {
        }
        catch (JWNLException e) {
            throw new WordnetError((Object)this, (Throwable)e);
        }
        return this.ptnlToStrings(null, ptnl);
    }

    public String[] getAllHolonyms(String query, String pos) {
        Synset[] synsets;
        block7: {
            synsets = this.allSynsets(query, pos);
            if (synsets != null) break block7;
            return null;
        }
        try {
            LinkedList l = new LinkedList();
            int i = 0;
            while (i < synsets.length) {
                if (synsets[i] != null) {
                    PointerTargetNodeList ptnl = null;
                    try {
                        ptnl = PointerUtils.getInstance().getHolonyms(synsets[i]);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    this.getLemmaSet(ptnl, l);
                }
                ++i;
            }
            l.remove(query);
            return RiWordnet.toStrArr(l);
        }
        catch (JWNLException e) {
            throw new WordnetError((Object)this, (Throwable)e);
        }
    }

    public String[] getCoordinates(String query, String pos) {
        Synset synset2;
        String[] result;
        block5: {
            result = null;
            synset2 = this.getSynsetAtIndex(query, pos, 1);
            if (synset2 != null) break block5;
            return null;
        }
        try {
            PointerTargetNodeList ptnl = PointerUtils.getInstance().getCoordinateTerms(synset2);
            if (ptnl != null) {
                result = this.ptnlToStrings(query, ptnl);
            }
        }
        catch (NullPointerException synset2) {
        }
        catch (JWNLException e) {
            throw new WordnetError((Object)this, (Throwable)e);
        }
        return result;
    }

    public String[] getCoordinates(int id) {
        Synset synset2;
        String[] result;
        block5: {
            result = null;
            synset2 = this.getSynsetAtId(id);
            if (synset2 != null) break block5;
            return null;
        }
        try {
            PointerTargetNodeList ptnl = PointerUtils.getInstance().getCoordinateTerms(synset2);
            if (ptnl != null) {
                result = this.ptnlToStrings(null, ptnl);
            }
        }
        catch (NullPointerException synset2) {
        }
        catch (JWNLException e) {
            throw new WordnetError((Object)this, (Throwable)e);
        }
        return result;
    }

    public String[] getAllCoordinates(String query, String pos) {
        Synset[] synsets;
        block7: {
            synsets = this.allSynsets(query, pos);
            if (synsets != null) break block7;
            return null;
        }
        try {
            LinkedList l = new LinkedList();
            int i = 0;
            while (i < synsets.length) {
                if (synsets[i] != null) {
                    PointerTargetNodeList ptnl = null;
                    try {
                        ptnl = PointerUtils.getInstance().getCoordinateTerms(synsets[i]);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    this.getLemmaSet(ptnl, l);
                }
                ++i;
            }
            l.remove(query);
            return RiWordnet.toStrArr(l);
        }
        catch (JWNLException e) {
            throw new WordnetError((Object)this, (Throwable)e);
        }
    }

    public String[] getVerbGroup(String query, String pos) {
        Synset synset;
        PointerTargetNodeList ptnl;
        block6: {
            ptnl = null;
            try {
                synset = this.getSynsetAtIndex(query, pos, 1);
                if (synset != null) break block6;
                return null;
            }
            catch (JWNLException e) {
                throw new WordnetError((Object)this, (Throwable)e);
            }
        }
        try {
            ptnl = PointerUtils.getInstance().getVerbGroup(synset);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (ptnl == null) {
            return null;
        }
        return this.ptnlToStrings(query, ptnl);
    }

    public String[] getVerbGroup(int id) {
        Synset synset;
        PointerTargetNodeList ptnl;
        block6: {
            ptnl = null;
            try {
                synset = this.getSynsetAtId(id);
                if (synset != null) break block6;
                return null;
            }
            catch (JWNLException e) {
                throw new WordnetError((Object)this, (Throwable)e);
            }
        }
        try {
            ptnl = PointerUtils.getInstance().getVerbGroup(synset);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (ptnl == null) {
            return null;
        }
        return this.ptnlToStrings(null, ptnl);
    }

    public String[] getAllVerbGroups(String query, String pos) {
        Synset[] synsets;
        block7: {
            synsets = this.allSynsets(query, pos);
            if (synsets != null) break block7;
            return null;
        }
        try {
            LinkedList l = new LinkedList();
            int i = 0;
            while (i < synsets.length) {
                if (synsets[i] != null) {
                    PointerTargetNodeList ptnl = null;
                    try {
                        ptnl = PointerUtils.getInstance().getVerbGroup(synsets[i]);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    this.getLemmaSet(ptnl, l);
                }
                ++i;
            }
            l.remove(query);
            return RiWordnet.toStrArr(l);
        }
        catch (JWNLException e) {
            throw new WordnetError((Object)this, (Throwable)e);
        }
    }

    public String[] getDerivedTerms(String query, String pos) {
        return this.getPointerTargetsAtIndex(query, pos, PointerType.DERIVED, 1);
    }

    public String[] getDerivedTerms(int id) {
        return this.getPointerTargetsAtId(id, PointerType.DERIVED);
    }

    public String[] getAllDerivedTerms(String query, String pos) {
        return this.getAllPointerTargets(query, pos, PointerType.DERIVED);
    }

    public String[] getAlsoSees(String query, String pos) {
        return this.getPointerTargetsAtIndex(query, pos, PointerType.SEE_ALSO, 1);
    }

    public String[] getAlsoSees(int senseId) {
        return this.getPointerTargetsAtId(senseId, PointerType.SEE_ALSO);
    }

    public String[] getAllAlsoSees(String query, String pos) {
        return this.getAllPointerTargets(query, pos, PointerType.SEE_ALSO);
    }

    public String[] getNominalizations(String query, String pos) {
        return this.getPointerTargetsAtIndex(query, pos, PointerType.NOMINALIZATION, 1);
    }

    public String[] getNominalizations(int id) {
        return this.getPointerTargetsAtId(id, PointerType.NOMINALIZATION);
    }

    public String[] getAllNominalizations(String query, String pos) {
        return this.getAllPointerTargets(query, pos, PointerType.NOMINALIZATION);
    }

    public String[] getSimilar(String query, String pos) {
        return this.getPointerTargetsAtIndex(query, pos, PointerType.SIMILAR_TO, 1);
    }

    public String[] getSimilar(int id) {
        return this.getPointerTargetsAtId(id, PointerType.SIMILAR_TO);
    }

    public String[] getAllSimilar(String query, String pos) {
        return this.getAllPointerTargets(query, pos, PointerType.SIMILAR_TO);
    }

    private POS convertPos(CharSequence pos) {
        if (pos == null) {
            pos = "";
        }
        return this.convertPos(pos.toString());
    }

    private PointerTargetNodeList getPointerTargets(Synset synset, PointerType type) throws JWNLException {
        PointerTarget[] pta;
        if (synset == null) {
            return null;
        }
        try {
            pta = synset.getTargets(type);
            if (pta == null || pta.length == 0) {
                return null;
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        return new PointerTargetNodeList(pta);
    }

    public boolean isIgnoringCompoundWords() {
        return this.ignoreCompoundWords;
    }

    public void ignoreCompoundWords(boolean ignoreCompoundWords) {
        this.ignoreCompoundWords = ignoreCompoundWords;
    }

    public boolean isIgnoringUpperCaseWords() {
        return this.ignoreUpperCaseWords;
    }

    public void ignoreUpperCaseWords(boolean ignoreUpperCaseWords) {
        this.ignoreUpperCaseWords = ignoreUpperCaseWords;
    }

    private String[] getAllPointerTargets(String word, String pos, PointerType type) {
        Synset[] syns = this.allSynsets(word, pos);
        if (syns == null || syns.length < 1) {
            return null;
        }
        LinkedList result = new LinkedList();
        int i = 0;
        while (i < syns.length) {
            try {
                PointerTargetNodeList ptnl = this.getPointerTargets(syns[i], type);
                String[] targets = this.ptnlToStrings(word, ptnl);
                if (targets != null) {
                    int j = 0;
                    while (j < targets.length) {
                        if (targets[j] != null) {
                            this.addLemma(targets[j], result);
                        }
                        ++j;
                    }
                }
            }
            catch (JWNLException e) {
                throw new WordnetError(e);
            }
            ++i;
        }
        result.remove(word);
        return RiWordnet.toStrArr(result);
    }

    private String[] getPointerTargetsAtIndex(String word, String pos, PointerType type, int index) {
        Synset synset;
        block3: {
            try {
                synset = this.getSynsetAtIndex(word, pos, index);
                if (synset != null) break block3;
                return null;
            }
            catch (JWNLException e) {
                throw new WordnetError((Object)this, (Throwable)e);
            }
        }
        return this.ptnlToStrings(word, this.getPointerTargets(synset, type));
    }

    private String[] getPointerTargetsAtId(int id, PointerType type) {
        Synset synset = this.getSynsetAtId(id);
        if (synset == null) {
            return null;
        }
        try {
            return this.ptnlToStrings(null, this.getPointerTargets(synset, type));
        }
        catch (JWNLException e) {
            throw new WordnetError(e);
        }
    }

    class ComparableIndexWord
    implements Comparable {
        IndexWord iw;
        int polysemy = -1;

        public ComparableIndexWord(IndexWord current, int polysemy) {
            this.iw = current;
            this.polysemy = polysemy;
        }

        public String toString() {
            return String.valueOf(this.iw.toString()) + "polysemy=" + this.polysemy;
        }

        public int compareTo(Object arg0) {
            ComparableIndexWord ciw = (ComparableIndexWord)arg0;
            if (ciw.polysemy == this.polysemy) {
                return 0;
            }
            return ciw.polysemy > this.polysemy ? 1 : -1;
        }
    }
}

