/*
 * Decompiled with CFR 0.152.
 */
package rita.wordnet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import processing.core.PApplet;
import rita.wordnet.RandomAccessByteArray;
import rita.wordnet.RiWordnet;
import rita.wordnet.WordnetError;
import rita.wordnet.WordnetUtil;

public class RiZipReader {
    public boolean dbug = false;
    private Map fileSizes;
    private Map fileContents;
    private String zipfileName;
    private PApplet pApplet;

    public RiZipReader(PApplet p, String archiveName) {
        this(p, archiveName, null);
    }

    public RiZipReader(PApplet p, String archiveName, InputStream is) {
        this.pApplet = p;
        this.zipfileName = archiveName;
        if (is != null) {
            this.init(is);
        }
        RiWordnet.zipReader = this;
    }

    public void dispose() {
        if (this.fileSizes != null) {
            this.fileSizes.clear();
            this.fileSizes = null;
        }
        if (this.fileContents != null) {
            this.fileContents.clear();
            this.fileContents = null;
        }
    }

    public Iterator iterator() {
        if (this.fileContents == null) {
            this.init();
        }
        return this.fileContents.keySet().iterator();
    }

    public byte[] getResource(String name) {
        if (this.fileContents == null) {
            this.init();
        }
        return (byte[])this.fileContents.get(name);
    }

    private void init() {
        this.init(null);
    }

    private void init(InputStream is) {
        this.fileContents = new Hashtable();
        try {
            if (is == null) {
                is = WordnetUtil.openStream(this.pApplet, this.zipfileName);
            }
            ZipInputStream zis = this.openZipStream(is);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                int size;
                if (ze.isDirectory()) continue;
                if (this.dbug) {
                    System.out.println("file: " + ze.getName() + " " + ze.getSize() + " bytes");
                }
                if ((size = (int)ze.getSize()) == -1) {
                    if (this.fileSizes == null) {
                        this.cacheFileSizes();
                    }
                    size = (Integer)this.fileSizes.get(ze.getName());
                }
                byte[] b = new byte[size];
                int rb = 0;
                int chunk = 0;
                while (size - rb > 0) {
                    chunk = zis.read(b, rb, size - rb);
                    if (chunk == -1) break;
                    rb += chunk;
                }
                this.fileContents.put(ze.getName(), b);
                if (!this.dbug) continue;
                System.out.println(String.valueOf(ze.getName()) + " size=" + size + ", csize=" + ze.getCompressedSize());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int origGetBytes(ZipInputStream zis, int size, byte[] b) throws IOException {
        int rb = 0;
        int chunk = 0;
        while (size - rb > 0) {
            chunk = zis.read(b, rb, size - rb);
            if (chunk == -1) break;
            rb += chunk;
        }
        return rb;
    }

    protected boolean readByteArray(InputStream in, byte[] array, int offset, int size) throws IOException {
        int off = offset;
        int left = size;
        while (left > 0) {
            int read = in.read(array, off, left);
            if (read == -1) {
                return false;
            }
            off += read;
            left -= read;
        }
        return true;
    }

    private ZipInputStream openZipStream(InputStream is) {
        if (is instanceof JarInputStream) {
            System.err.println("[WARN] found JarInputStream: " + is);
            return new ZipInputStream(is);
        }
        if (is instanceof GZIPInputStream) {
            System.err.println("[WARN] found GZIPInputStream: " + is);
            return (ZipInputStream)is;
        }
        if (is instanceof ZipInputStream) {
            System.err.println("ZipInputStream: " + is);
            return (ZipInputStream)is;
        }
        if (is instanceof InputStream) {
            return new ZipInputStream(is);
        }
        throw new WordnetError("Unable to open zipStream for " + this.zipfileName);
    }

    private void cacheFileSizes() {
        System.err.println("[WARN] ZipResources: loading size cache... ");
        this.fileSizes = new HashMap();
        try {
            InputStream is = WordnetUtil.openStream(this.pApplet, this.zipfileName);
            ZipInputStream zis = this.openZipStream(is);
            ZipEntry zipentry = zis.getNextEntry();
            while (zipentry != null) {
                if (this.dbug) {
                    System.out.println(this.dumpZipEntry(zipentry));
                }
                this.fileSizes.put(zipentry.getName(), new Integer((int)zipentry.getSize()));
                zis.closeEntry();
                zipentry = zis.getNextEntry();
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String dumpZipEntry(ZipEntry ze) {
        StringBuffer sb = new StringBuffer();
        if (ze.isDirectory()) {
            sb.append("d ");
        } else {
            sb.append("f ");
        }
        if (ze.getMethod() == 0) {
            sb.append("stored   ");
        } else {
            sb.append("defaulted ");
        }
        sb.append(ze.getName());
        sb.append("\t");
        sb.append("" + ze.getSize());
        if (ze.getMethod() == 8) {
            sb.append("/" + ze.getCompressedSize());
        }
        return sb.toString();
    }

    public static void mainx(String[] args) throws IOException {
        RiZipReader zr = new RiZipReader(null, "examples/mthesaur.dat");
        Iterator iter = zr.iterator();
        while (iter.hasNext()) {
            String fname = (String)iter.next();
            byte[] buf = zr.getResource(fname);
            RandomAccessByteArray rab = new RandomAccessByteArray(fname, buf);
            try {
                System.err.println(String.valueOf(fname) + ": " + rab.length() + " bytes");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        System.err.println(System.getProperty("java.vm.version"));
        RiWordnet wordnet = new RiWordnet(null);
        String[] result = wordnet.getAllHyponyms("cat", "n");
        System.err.println(result == null ? "null" : "" + Arrays.asList(result));
    }
}

