/*
 * Decompiled with CFR 0.152.
 */
package rita.wordnet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import rita.wordnet.WordnetError;

public class UnicodeInputStream
extends InputStream {
    private static final String DEFAULT_ENCODING = "UTF-8";
    public static final int BOM_SIZE = 4;
    private boolean initd;
    private int BOMOffset = -1;
    private String defaultEnc;
    private String encoding;
    private PushbackInputStream internalIn;

    public UnicodeInputStream(InputStream in) {
        this(in, DEFAULT_ENCODING);
    }

    public UnicodeInputStream(InputStream in, String defaultEnc) {
        this.internalIn = new PushbackInputStream(in, 4);
        this.defaultEnc = defaultEnc;
        try {
            this.init();
        }
        catch (IOException e) {
            throw new WordnetError(e);
        }
    }

    public String getDefaultEncoding() {
        return this.defaultEnc;
    }

    public String getEncoding() {
        if (!this.initd) {
            try {
                this.init();
            }
            catch (IOException ex) {
                IllegalStateException ise = new IllegalStateException("Init method failed.");
                ise.initCause(ise);
                throw ise;
            }
        }
        return this.encoding;
    }

    protected void init() throws IOException {
        if (this.initd) {
            return;
        }
        int unread = -1;
        byte[] bom = new byte[4];
        int n = this.internalIn.read(bom, 0, bom.length);
        if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            this.encoding = "UTF-32BE";
            unread = n - 4;
        } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            this.encoding = "UTF-32LE";
            unread = n - 4;
        } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            this.encoding = DEFAULT_ENCODING;
            unread = n - 3;
        } else if (bom[0] == -2 && bom[1] == -1) {
            this.encoding = "UTF-16BE";
            unread = n - 2;
        } else if (bom[0] == -1 && bom[1] == -2) {
            this.encoding = "UTF-16LE";
            unread = n - 2;
        } else {
            this.encoding = this.defaultEnc;
            unread = n;
        }
        this.BOMOffset = 4 - unread;
        if (unread > 0) {
            this.internalIn.unread(bom, n - unread, unread);
        }
        this.initd = true;
    }

    public void close() throws IOException {
        this.initd = true;
        this.internalIn.close();
    }

    public int read() throws IOException {
        this.initd = true;
        return this.internalIn.read();
    }

    public int getBOMOffset() {
        return this.BOMOffset;
    }
}

