/*
 * Decompiled with CFR 0.152.
 */
package rita.wordnet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.file.DictionaryFile;
import net.didion.jwnl.dictionary.file.DictionaryFileType;
import net.didion.jwnl.princeton.file.PrincetonRandomAccessDictionaryFile;
import rita.wordnet.RandomAccessByteArray;
import rita.wordnet.RandomAccessIF;
import rita.wordnet.RiWordnet;
import rita.wordnet.WordnetError;
import rita.wordnet.WordnetUtil;

public class WordnetDictionaryFile
extends PrincetonRandomAccessDictionaryFile {
    private static final Map _posToExtMap = new HashMap(4, 1.0f);
    private static final Map _fileTypeToFileNameMap;
    private static final String NOUN_EXT = "noun";
    private static final String VERB_EXT = "verb";
    private static final String ADJECTIVE_EXT = "adj";
    private static final String ADVERB_EXT = "adv";
    private static final boolean DBUG = false;

    static {
        _posToExtMap.put(POS.NOUN, NOUN_EXT);
        _posToExtMap.put(POS.VERB, VERB_EXT);
        _posToExtMap.put(POS.ADJECTIVE, ADJECTIVE_EXT);
        _posToExtMap.put(POS.ADVERB, ADVERB_EXT);
        _fileTypeToFileNameMap = new HashMap(3, 1.0f);
        _fileTypeToFileNameMap.put(DictionaryFileType.INDEX, new FileNames("idx", "index"));
        _fileTypeToFileNameMap.put(DictionaryFileType.DATA, new FileNames("dat", "data"));
        _fileTypeToFileNameMap.put(DictionaryFileType.EXCEPTION, new FileNames("exc", "exc"));
    }

    public WordnetDictionaryFile() {
    }

    public WordnetDictionaryFile(RandomAccessIF file, POS pos, DictionaryFileType fileType) {
        this._pos = pos;
        this.randomAccessFile = file;
        this._fileType = fileType;
    }

    public WordnetDictionaryFile(String path, POS pos, DictionaryFileType fileType) {
        this(path, pos, fileType, "r");
    }

    public WordnetDictionaryFile(String path, POS pos, DictionaryFileType fileType, String permissions) {
        super(path, pos, fileType);
        this._permissions = permissions;
    }

    public DictionaryFile newInstance(String path, POS pos, DictionaryFileType fileType) {
        return new WordnetDictionaryFile(path, pos, fileType);
    }

    private static String getExtension(POS pos) {
        return (String)_posToExtMap.get(pos);
    }

    private static FileNames getFileNames(DictionaryFileType type) {
        return (FileNames)_fileTypeToFileNameMap.get(type);
    }

    private static String makeWindowsFilename(String posStr, String fileTypeStr) {
        return String.valueOf(posStr) + "." + fileTypeStr;
    }

    private static String makeNonWindowsFilename(String posStr, String fileTypeStr) {
        return String.valueOf(fileTypeStr) + "." + posStr;
    }

    protected String makeFilename() {
        String s = null;
        String posString = WordnetDictionaryFile.getExtension(this.getPOS());
        if (this.getFileType() == DictionaryFileType.EXCEPTION) {
            s = WordnetDictionaryFile.makeWindowsFilename(posString, WordnetDictionaryFile.getFileNames((DictionaryFileType)this.getFileType())._windowsFileTypeName);
            return s;
        }
        s = WordnetDictionaryFile.makeNonWindowsFilename(posString, WordnetDictionaryFile.getFileNames((DictionaryFileType)this.getFileType())._nonWindowsFileTypeName);
        return s;
    }

    public static String buildFilename(POS pos, DictionaryFileType getFileType) {
        String s = null;
        String posString = WordnetDictionaryFile.getExtension(pos);
        if (getFileType == DictionaryFileType.EXCEPTION) {
            s = WordnetDictionaryFile.makeWindowsFilename(posString, WordnetDictionaryFile.getFileNames((DictionaryFileType)getFileType)._windowsFileTypeName);
            return s;
        }
        s = WordnetDictionaryFile.makeNonWindowsFilename(posString, WordnetDictionaryFile.getFileNames((DictionaryFileType)getFileType)._nonWindowsFileTypeName);
        return s;
    }

    protected void openFile(File fileLoc) throws IOException {
        if (!fileLoc.exists()) {
            throw new WordnetError("Couldn't find file: " + fileLoc);
        }
        InputStream is = null;
        String fileName = fileLoc.getPath();
        if (RiWordnet.wordnetHome != null) {
            is = new FileInputStream(fileName);
        } else {
            is = WordnetUtil.openStream(RiWordnet.pApplet, fileName);
            if (is == null) {
                System.err.println("[ERROR] Unable to open bad stream: " + fileName);
                System.exit(1);
            }
        }
        this.randomAccessFile = new RandomAccessByteArray(fileName, is);
    }

    private static final class FileNames {
        String _windowsFileTypeName;
        String _nonWindowsFileTypeName;

        public FileNames(String windowsFileTypeName, String nonWindowsFileTypeName) {
            this._windowsFileTypeName = windowsFileTypeName;
            this._nonWindowsFileTypeName = nonWindowsFileTypeName;
        }
    }
}

