/*
 * Decompiled with CFR 0.152.
 */
package rita.wordnet;

import java.util.Iterator;
import java.util.List;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.IndexWordSet;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.PointerUtils;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.list.PointerTargetNode;
import net.didion.jwnl.data.relationship.AsymmetricRelationship;
import net.didion.jwnl.data.relationship.RelationshipFinder;
import net.didion.jwnl.data.relationship.RelationshipList;
import net.didion.jwnl.dictionary.Dictionary;
import rita.wordnet.RiWordnet;

public class WordnetDistance {
    private static final POS[] wordTypes = new POS[]{POS.NOUN};
    private Dictionary dictionary;
    private static final int MAX_STRING_LENGTH = 500;
    private String[][] str = new String[2][];
    private float[][] dist = new float[501][501];

    public WordnetDistance(Dictionary wordnetDict) {
        int i = 0;
        while (i <= 500) {
            this.dist[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j <= 500) {
            this.dist[0][j] = j;
            ++j;
        }
        this.dictionary = wordnetDict;
    }

    public float getSentenceDistance(String string1, String string2) {
        float cost = 0.0f;
        this.str[0] = string1.split(" ");
        this.str[1] = string2.split(" ");
        int i = 1;
        while (i <= this.str[0].length) {
            int j = 1;
            while (j <= this.str[1].length) {
                try {
                    cost = this.getLemmaDistance(this.str[0][i - 1], this.str[1][j - 1]);
                }
                catch (Exception e) {
                    cost = 1.0f;
                }
                this.dist[i][j] = Math.min(Math.min(this.dist[i - 1][j] + 1.0f, this.dist[i][j - 1] + 1.0f), this.dist[i - 1][j - 1] + cost);
                ++j;
            }
            ++i;
        }
        return this.dist[this.str[0].length][this.str[1].length];
    }

    public float getLemmaDistance(String lemma1, String lemma2) {
        float smallestD = 1.0f;
        if (lemma1.equals(lemma2)) {
            smallestD = 0.0f;
        } else {
            try {
                IndexWordSet WORDSET1 = this.dictionary.lookupAllIndexWords(lemma1);
                IndexWordSet WORDSET2 = this.dictionary.lookupAllIndexWords(lemma2);
                int i = 0;
                while (i < wordTypes.length) {
                    IndexWord WORD2;
                    IndexWord WORD1;
                    float d;
                    POS p = wordTypes[i];
                    if (WORDSET1.isValidPOS(p) && WORDSET2.isValidPOS(p) && (d = this.getWordDistance(WORD1 = WORDSET1.getIndexWord(p), WORD2 = WORDSET2.getIndexWord(p))) < smallestD) {
                        smallestD = d;
                    }
                    ++i;
                }
            }
            catch (JWNLException e) {
                System.err.println("Error in WordNet module: " + e);
                return 1.0f;
            }
        }
        return smallestD;
    }

    private float getWordDistance(IndexWord start, IndexWord end) throws JWNLException {
        float distance = 1.0f;
        int i = 1;
        while (i <= start.getSenseCount()) {
            int j = 1;
            while (j <= end.getSenseCount()) {
                block8: {
                    RelationshipList relList;
                    try {
                        relList = RelationshipFinder.getInstance().findRelationships(start.getSense(i), end.getSense(j), PointerType.HYPERNYM);
                    }
                    catch (Exception e) {
                        break block8;
                    }
                    int k = 0;
                    Iterator relListItr = relList.iterator();
                    while (relListItr.hasNext()) {
                        AsymmetricRelationship rel = (AsymmetricRelationship)relListItr.next();
                        int cpIndex = rel.getCommonParentIndex();
                        int relLength = rel.getDepth();
                        int depthCpLeaf = Math.max(relLength - cpIndex, cpIndex);
                        PointerTargetNode cpNode = (PointerTargetNode)rel.getNodeList().get(cpIndex);
                        Synset cpSynset = cpNode.getSynset();
                        List cpHypListList = PointerUtils.getInstance().getHypernymTree(cpSynset, 50).toList();
                        int depthRootCp = -1;
                        Iterator cpHypListListItr = cpHypListList.iterator();
                        while (cpHypListListItr.hasNext()) {
                            int depth = ((List)cpHypListListItr.next()).size();
                            if (depthRootCp == -1) {
                                depthRootCp = depth;
                                continue;
                            }
                            if (depth >= depthRootCp) continue;
                            depthRootCp = depth;
                        }
                        float newDistance = (float)depthCpLeaf / (float)(depthRootCp + depthCpLeaf);
                        if (newDistance < distance) {
                            distance = newDistance;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return distance;
    }

    public static void main(String[] args) {
        RiWordnet c = new RiWordnet(null);
        WordnetDistance wd = new WordnetDistance(c.getDictionary());
    }
}

