/*
 * Decompiled with CFR 0.152.
 */
package rita.wordnet;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.Dictionary;
import rita.wordnet.RiFilter;
import rita.wordnet.RiWordnet;
import rita.wordnet.Wordnet;
import rita.wordnet.WordnetError;
import rita.wordnet.WordnetUtil;

public class WordnetFilters
implements Wordnet {
    protected Dictionary dictionary;
    protected boolean ignoreCompoundWords;
    protected boolean ignoreUpperCaseWords;
    protected Map filterCache;

    public WordnetFilters(RiWordnet wl) {
        this.dictionary = wl.getDictionary();
        this.filterCache = new HashMap();
        this.ignoreCompoundWords = wl.isIgnoringCompoundWords();
        this.ignoreUpperCaseWords = wl.isIgnoringUpperCaseWords();
    }

    protected List filter(RiFilter filter, POS pos, int maxResults) {
        if (pos == null) {
            return null;
        }
        LinkedList<String> result = new LinkedList<String>();
        Iterator it = this.iterator(pos);
        while (it.hasNext()) {
            String lemma = this.nextWord(it);
            if (lemma == null || !filter.accept(lemma)) continue;
            result.add(lemma);
        }
        return result;
    }

    public List filter(int filterFlag, String word, POS pos, int maxResults) {
        RiFilter filter = RiFilter.create(filterFlag, word);
        return this.filter(filter, pos, maxResults);
    }

    public List filter(int filterFlag, String word, POS pos) {
        return this.filter(filterFlag, word, pos, Integer.MAX_VALUE);
    }

    public List orFilter(int[] filterFlags, String[] filterPatterns, POS pos, int maxResults) {
        if (filterFlags.length != filterPatterns.length) {
            throw new IllegalArgumentException("[ERROR] must pass equal # of flags and patterns!");
        }
        RiFilter[] filters = new RiFilter[filterFlags.length];
        int i = 0;
        while (i < filterPatterns.length) {
            filters[i] = RiFilter.create(filterFlags[i], filterPatterns[i]);
            ++i;
        }
        return this.orFilter(filters, pos, maxResults);
    }

    public List orFilter(RiFilter[] filters, POS pos, int MaxResults) {
        if (pos == null) {
            return null;
        }
        LinkedList<String> result = new LinkedList<String>();
        Iterator it = this.iterator(pos);
        block0: while (it.hasNext()) {
            String lemma = this.nextWord(it);
            if (lemma == null) continue;
            int i = 0;
            while (i < filters.length) {
                if (filters[i].accept(lemma)) {
                    result.add(lemma);
                    continue block0;
                }
                ++i;
            }
        }
        return result;
    }

    public List orFilter(RiFilter[] filters, POS pos) {
        return this.orFilter(filters, pos, Integer.MAX_VALUE);
    }

    public List andFilter(int[] filterFlags, String[] filterPatterns, POS pos, int maxResults) {
        if (filterFlags.length != filterPatterns.length) {
            throw new IllegalArgumentException("[ERROR] must pass equal # of flags and patterns!");
        }
        RiFilter[] filters = new RiFilter[filterFlags.length];
        int i = 0;
        while (i < filterPatterns.length) {
            filters[i] = RiFilter.create(filterFlags[i], filterPatterns[i]);
            ++i;
        }
        return this.andFilter(filters, pos, maxResults);
    }

    public List andFilter(RiFilter[] filters, POS pos, int maxResults) {
        if (pos == null) {
            return null;
        }
        LinkedList<String> result = new LinkedList<String>();
        Iterator it = this.iterator(pos);
        block0: while (it.hasNext()) {
            String lemma = this.nextWord(it);
            if (lemma == null) continue;
            int i = 0;
            while (i < filters.length) {
                if (!filters[i].accept(lemma)) continue block0;
                result.add(lemma);
                ++i;
            }
        }
        return result;
    }

    public List andFilter(RiFilter[] filters, POS pos) {
        return this.andFilter(filters, pos, Integer.MAX_VALUE);
    }

    protected Iterator iterator(POS pos) {
        return WordnetFilters.iterator(this.dictionary, pos);
    }

    Iterator lemmaIterator(Dictionary d, POS pos) {
        String tag = String.valueOf(pos.getKey()) + "Set";
        HashSet<String> result = (HashSet<String>)this.filterCache.get(tag);
        if (result == null) {
            result = new HashSet<String>();
            Iterator it = WordnetFilters.iterator(d, pos);
            while (it.hasNext()) {
                String lemma = this.nextWord(it);
                if (lemma == null) continue;
                result.add(lemma);
            }
            this.filterCache.put(tag, result);
        }
        return result.iterator();
    }

    static Iterator iterator(Dictionary d, POS pos) {
        Iterator it = null;
        try {
            it = d.getIndexWordIterator(pos);
        }
        catch (JWNLException e) {
            throw new WordnetError();
        }
        return it;
    }

    private String nextWord(Iterator it) {
        IndexWord iw = (IndexWord)it.next();
        String lemma = iw.getLemma();
        if (lemma == null) {
            return null;
        }
        if (this.ignoreCompoundWords && RiWordnet.isCompound(lemma)) {
            return null;
        }
        if (this.ignoreUpperCaseWords && WordnetUtil.startsWithUppercase(lemma)) {
            return null;
        }
        return lemma;
    }
}

