/*
 * Decompiled with CFR 0.152.
 */
package rita.wordnet;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Synset;
import rita.wordnet.RiGlossFilter;
import rita.wordnet.RiWordnet;
import rita.wordnet.WordnetError;
import rita.wordnet.WordnetFilters;
import rita.wordnet.WordnetUtil;

public class WordnetGlossFilter
extends WordnetFilters {
    private IndexWord iw = null;

    public WordnetGlossFilter(RiWordnet wl) {
        super(wl);
    }

    protected List filter(int filterType, POS pos, int maxResults) {
        return this.filter(RiGlossFilter.create(filterType, null), pos, maxResults);
    }

    protected List filter(int filterType, POS pos) {
        return this.filter(RiGlossFilter.create(filterType, null), pos, Integer.MAX_VALUE);
    }

    protected List filter(RiGlossFilter filter, POS pos, int maxResults) {
        if (pos == null) {
            return null;
        }
        HashSet<String> results = new HashSet<String>();
        Iterator it = this.iterator(pos);
        while (it.hasNext()) {
            String result;
            String gloss;
            String lemma = this.nextWord(it);
            if (this.iw == null) {
                throw new RuntimeException("NULL IW!");
            }
            if (lemma == null || this.iw == null || (gloss = this.nextGloss()) == null || (result = filter.accept(lemma, gloss)) == null) continue;
            results.add(result);
            if (results.size() >= maxResults) break;
        }
        ArrayList l = new ArrayList(results.size());
        Iterator i = results.iterator();
        while (i.hasNext()) {
            l.add(i.next());
        }
        return l;
    }

    private String nextWord(Iterator it) {
        this.iw = (IndexWord)it.next();
        String lemma = this.iw.getLemma();
        if (lemma == null) {
            return null;
        }
        if (this.ignoreCompoundWords && RiWordnet.isCompound(lemma)) {
            return null;
        }
        if (this.ignoreUpperCaseWords && WordnetUtil.startsWithUppercase(lemma)) {
            return null;
        }
        return lemma;
    }

    private String nextGloss() {
        if (this.iw == null) {
            return null;
        }
        int senseCount = this.iw.getSenseCount();
        if (senseCount < 1) {
            return null;
        }
        String gloss = null;
        Synset[] syns = new Synset[senseCount];
        int i = 0;
        while (i < syns.length) {
            try {
                syns[i] = this.iw.getSense(i + 1);
                if (syns[i] != null && (gloss = syns[i].getGloss()) != null) {
                    break;
                }
            }
            catch (JWNLException e) {
                throw new WordnetError(e);
            }
            ++i;
        }
        this.iw = null;
        return gloss;
    }

    public static void main(String[] args) throws Exception {
        RiWordnet wl = new RiWordnet(null);
        WordnetGlossFilter wf = new WordnetGlossFilter(wl);
        Iterator i = wf.iterator(POS.NOUN);
        String lemma = wf.nextWord(i);
        String gloss = wf.nextGloss();
        System.out.println(String.valueOf(lemma) + " / " + gloss);
    }
}

