/*
 * Decompiled with CFR 0.152.
 */
package rita.wordnet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import processing.core.PApplet;
import rita.wordnet.UnicodeInputStream;
import rita.wordnet.WordnetError;

public abstract class WordnetUtil {
    static final String QQ = "";
    static final String BN = "\n";
    static final String SPC = " ";
    static final int DEFAULT_NUM_STRINGS = 100;
    static String OS_SLASH = "/";
    static final boolean DBUG = false;
    static final String MAC = "mac";
    static final String LINUX = "linux";
    static final String WINDOWS = "windows";
    static final String OS_UNDEFINED = "undefined";
    static final String[] OSs;
    static boolean printedNullParentWarning;
    static final char[] PUNCTUATION;
    protected static Pattern examplePattern;
    static /* synthetic */ Class class$0;

    static {
        try {
            OS_SLASH = System.getProperty("file.separator");
        }
        catch (RuntimeException e) {
            System.err.println("[WARN] Unable to determine OS_SLASH, using '" + OS_SLASH + "'");
        }
        OSs = new String[]{WINDOWS, MAC, LINUX};
        printedNullParentWarning = false;
        PUNCTUATION = new char[]{',', ';', ':', '!', '?', ')', '(', '[', ']', '.', '#', '\"', '\'', '!', '@', '$', '%', '&', '}', '<', '>', '|', '+', '=', '-', '_', '\\', '/', '*', '{', '^'};
    }

    static String getOS() {
        String os = System.getProperty("os.name");
        int i = 0;
        while (i < OSs.length) {
            if (os.toLowerCase().indexOf(OSs[i]) >= 0) {
                return OSs[i];
            }
            ++i;
        }
        System.err.println("[WARN] Undefined-OS: " + os);
        return OS_UNDEFINED;
    }

    static String exceptionToString(Throwable e) {
        return WordnetUtil.exceptionToString(e, true);
    }

    static String exceptionToString(Throwable e, boolean miniStack) {
        if (e == null) {
            return "null";
        }
        StringBuffer s = new StringBuffer(e + BN);
        StackTraceElement[] stes = e.getStackTrace();
        int i = 0;
        while (i < stes.length) {
            String ste = stes[i].toString();
            if (ste.matches(".*[0-9]+\\)")) {
                s.append("    " + ste + BN);
            }
            ++i;
        }
        return s.toString();
    }

    static Object removeRandom(Set set) {
        if (set == null || set.size() == 0) {
            return null;
        }
        ArrayList tmp = new ArrayList(set.size());
        tmp.addAll(set);
        System.out.println();
        Object o = WordnetUtil.removeRandom(tmp);
        Iterator i = set.iterator();
        while (i.hasNext()) {
            if (i.next() != o) continue;
            i.remove();
        }
        return o;
    }

    static Object removeRandom(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        int rand = (int)(Math.random() * (double)list.size());
        return list.remove(rand);
    }

    static String cwd() {
        return System.getProperty("user.dir");
    }

    static String join(String[] input, char delim) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < input.length) {
            sb.append(input[i]);
            if (i < input.length - 1) {
                sb.append(delim);
            }
            ++i;
        }
        return sb.toString();
    }

    static String join(List l, String delim) {
        StringBuffer sb = new StringBuffer();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    static boolean contains(String full, String search) {
        if (full == null) {
            return false;
        }
        return full.indexOf(search) > -1;
    }

    static boolean contains(StringBuffer full, char[] search) {
        if (full == null || search == null) {
            return false;
        }
        int i = 0;
        while (i < search.length) {
            if (full.indexOf(Character.toString(search[i])) > -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static String replace(String src, char c, char r) {
        if (src.indexOf(c) < 0) {
            return src;
        }
        StringBuffer buffer = new StringBuffer(src);
        int i = 0;
        while (i < buffer.length()) {
            if (buffer.charAt(i) == c) {
                buffer.replace(i, i + 1, String.valueOf(r));
            }
            ++i;
        }
        return buffer.toString();
    }

    static String[] split(String full) {
        return WordnetUtil.split(full, SPC);
    }

    static String[] split(CharSequence full, String delim) {
        String[] result;
        if (full != null) {
            StringTokenizer st = new StringTokenizer(full.toString(), delim);
            result = new String[st.countTokens()];
            int index = 0;
            while (index < result.length) {
                result[index] = st.nextToken();
                ++index;
            }
        } else {
            result = new String[]{};
        }
        return result;
    }

    static String join(Object[] full) {
        return WordnetUtil.join(full, SPC);
    }

    static String join(Object[] full, String delim) {
        String result = QQ;
        if (full != null) {
            int index = 0;
            while (index < full.length) {
                result = index == full.length - 1 ? String.valueOf(result) + full[index] : String.valueOf(result) + full[index] + delim;
                ++index;
            }
        }
        return result;
    }

    static String[] loadStringsLocal(String name) {
        if (!printedNullParentWarning) {
            System.err.println("[WARN] Null PApplet passed to WordnetUtil.loadStrings(" + name + ")");
            printedNullParentWarning = true;
        }
        InputStream is = WordnetUtil.openStreamLocal(name);
        return WordnetUtil.loadStrings(is);
    }

    static InputStream openStreamLocal(String streamName) {
        String[] guesses = new String[]{"src" + OS_SLASH + "data", "data", QQ};
        InputStream is = null;
        try {
            URL url = new URL(streamName);
            is = url.openStream();
        }
        catch (MalformedURLException url) {
        }
        catch (FileNotFoundException url) {
        }
        catch (Throwable e) {
            throw new WordnetError(e);
        }
        if (is != null && streamName.endsWith(".gz")) {
            try {
                is = new GZIPInputStream(is);
            }
            catch (Throwable e1) {
                throw new WordnetError("Unable to load archive: " + streamName, e1);
            }
        }
        if (is != null) {
            return is;
        }
        int i = 0;
        while (i < guesses.length) {
            String guess = String.valueOf(guesses[i]) + OS_SLASH + streamName;
            System.err.print("[INFO] Trying " + guess);
            try {
                is = new FileInputStream(guess);
                System.err.println("... OK");
            }
            catch (FileNotFoundException e) {
                System.err.println("... failed");
            }
            if (is != null) break;
            ++i;
        }
        if (is == null) {
            throw new WordnetError("Unable to create stream for: " + streamName);
        }
        return is;
    }

    static String[] loadStrings(PApplet p, String filename) {
        String[] result = null;
        result = p != null ? p.loadStrings(filename) : WordnetUtil.loadStringsLocal(filename);
        if (result == null) {
            throw new WordnetError("Unable to load file from: " + filename);
        }
        return result;
    }

    public static InputStream openStream(PApplet p, String filename) {
        if (p == null) {
            return WordnetUtil.openStreamLocal(filename);
        }
        InputStream is = WordnetUtil.openStreamRaw(p, filename);
        if (is == null) {
            throw new RuntimeException("found null for: " + filename);
        }
        if (is != null) {
            try {
                if (filename.toLowerCase().endsWith(".jar")) {
                    return new JarInputStream(is);
                }
                if (filename.toLowerCase().endsWith(".zip") || filename.toLowerCase().endsWith(".dat")) {
                    return new ZipInputStream(is);
                }
                if (filename.toLowerCase().endsWith(".gz")) {
                    return new GZIPInputStream(is);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (is == null) {
            throw new WordnetError("Unable to open stream: " + filename + " with pApplet=" + p);
        }
        return is;
    }

    public static URL getResourceURL(Class loc, String file) {
        try {
            return loc.getResource(file);
        }
        catch (Exception e) {
            throw new WordnetError(e);
        }
    }

    public static InputStream getResourceStream(Class loc, String file) {
        try {
            URL url = WordnetUtil.getResourceURL(loc, file);
            if (url != null) {
                InputStream is = url.openStream();
                return is;
            }
            throw new RuntimeException("Unable to load file: " + file);
        }
        catch (Exception e) {
            throw new WordnetError(e);
        }
    }

    private static InputStream openStreamRaw(PApplet p, String filename) {
        String cn;
        InputStream stream = null;
        try {
            URL url = new URL(filename);
            stream = url.openStream();
            return stream;
        }
        catch (MalformedURLException url) {
        }
        catch (FileNotFoundException url) {
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        ClassLoader cl = p.getClass().getClassLoader();
        stream = cl.getResourceAsStream("data/" + filename);
        if (stream != null && !(cn = stream.getClass().getName()).equals("sun.plugin.cache.EmptyInputStream")) {
            return stream;
        }
        stream = cl.getResourceAsStream(filename);
        if (stream != null && !(cn = stream.getClass().getName()).equals("sun.plugin.cache.EmptyInputStream")) {
            return stream;
        }
        try {
            try {
                try {
                    stream = new FileInputStream(p.dataPath(filename));
                    if (stream != null) {
                        return stream;
                    }
                }
                catch (IOException cn2) {
                    // empty catch block
                }
                try {
                    stream = new FileInputStream(p.sketchPath(filename));
                    if (stream != null) {
                        return stream;
                    }
                }
                catch (Exception cn2) {
                    // empty catch block
                }
                try {
                    stream = new FileInputStream(filename);
                    if (stream != null) {
                        return stream;
                    }
                }
                catch (IOException cn2) {
                }
            }
            catch (SecurityException cn2) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (stream == null) {
            throw new RuntimeException("No inputStream for: " + filename);
        }
        return stream;
    }

    public static InputStream openStream(File file) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
        }
        catch (IOException e) {
            if (file == null) {
                throw new RuntimeException("File passed to openStream() was null");
            }
            e.printStackTrace();
            throw new RuntimeException("Couldn't openStream() for " + file.getAbsolutePath());
        }
        if (is == null) {
            throw new RuntimeException("Couldn't openStream() for " + file.getAbsolutePath());
        }
        return new UnicodeInputStream(is);
    }

    static String[] loadStrings(InputStream input) {
        return WordnetUtil.loadStrings(input, 100);
    }

    static String[] loadStrings(InputStream input, int numLines) {
        if (input == null) {
            throw new WordnetError("Null input stream!");
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            String[] lines = new String[numLines];
            int lineCount = 0;
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (lineCount == lines.length) {
                    String[] temp = new String[lineCount << 1];
                    System.arraycopy(lines, 0, temp, 0, lineCount);
                    lines = temp;
                }
                lines[lineCount++] = line;
            }
            reader.close();
            if (lineCount == lines.length) {
                return lines;
            }
            String[] output = new String[lineCount];
            System.arraycopy(lines, 0, output, 0, lineCount);
            return output;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static String replace(String src, String r, String s) {
        int rLength = r.length();
        StringBuffer buffer = new StringBuffer(src);
        int i = 0;
        while (i + rLength <= buffer.length()) {
            if (buffer.substring(i, i + rLength).equals(r)) {
                buffer.replace(i, i + rLength, s);
            }
            ++i;
        }
        return buffer.toString();
    }

    static boolean contains(String full, String search, boolean ignoreLast) {
        if (full == null || search == null) {
            return false;
        }
        if (ignoreLast) {
            int idx = full.indexOf(search);
            return idx >= 0 && idx < full.length() - 1;
        }
        return full.indexOf(search) >= 0;
    }

    static boolean contains(String full, char search) {
        if (full == null || full.length() != 1) {
            return false;
        }
        return full.indexOf(Character.toString(search)) > -1;
    }

    static boolean contains(String full, char[] search) {
        if (full == null || search == null) {
            return false;
        }
        int i = 0;
        while (i < search.length) {
            if (full.indexOf(Character.toString(search[i])) > -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean contains(String full, String[] search) {
        if (full == null || search == null || search.length == 0) {
            return false;
        }
        int i = 0;
        while (i < search.length) {
            if (full.indexOf(search[i]) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean isPunct(CharSequence full) {
        if (full == null || full.length() > 1) {
            return false;
        }
        int i = 0;
        while (i < PUNCTUATION.length) {
            if (full.charAt(0) == PUNCTUATION[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static String replace(String src, int startIdx, int length, String replace) {
        String start = src.substring(0, startIdx);
        String end = src.substring(startIdx + length);
        return String.valueOf(start) + replace + end;
    }

    public static List asList(Set s) {
        ArrayList l = new ArrayList();
        if (s == null) {
            return l;
        }
        l.addAll(s);
        return l;
    }

    public static List asList(int[] ints) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        if (ints == null) {
            return l;
        }
        int i = 0;
        while (i < ints.length) {
            l.add(new Integer(ints[i]));
            ++i;
        }
        return l;
    }

    public static List asList(long[] longs) {
        ArrayList<Long> l = new ArrayList<Long>();
        if (longs == null) {
            return l;
        }
        int i = 0;
        while (i < longs.length) {
            l.add(new Long(longs[i]));
            ++i;
        }
        return l;
    }

    public static List asList(float[] floats) {
        ArrayList<Float> l = new ArrayList<Float>();
        if (floats == null) {
            return l;
        }
        int i = 0;
        while (i < floats.length) {
            l.add(new Float(floats[i]));
            ++i;
        }
        return l;
    }

    public static List asList(Object[] o) {
        if (o == null || o.length < 1) {
            return new ArrayList();
        }
        return Arrays.asList(o);
    }

    static byte[] loadBytes(PApplet p, String filename) {
        if (p != null) {
            return p.loadBytes(filename);
        }
        return WordnetUtil.loadBytesLocal(filename);
    }

    static byte[] loadBytes(PApplet p, InputStream is) {
        return PApplet.loadBytes((InputStream)is);
    }

    static byte[] loadBytesLocal(String filename) {
        InputStream is = WordnetUtil.openStreamLocal(filename);
        if (is != null) {
            return WordnetUtil.loadBytes(null, is);
        }
        System.err.println("The file \"" + filename + "\" " + "is missing or inaccessible, make sure " + "the URL is valid or that the file has been " + "added to your sketch and is readable.");
        return null;
    }

    static boolean startsWithUppercase(String lemma) {
        return Character.isUpperCase(lemma.charAt(0));
    }

    public static List parseExamples(String gloss) {
        if (gloss == null) {
            return null;
        }
        int idx = gloss.indexOf(34);
        if (idx < 0) {
            return null;
        }
        if (examplePattern == null) {
            examplePattern = Pattern.compile("\"([\\w ;',-.?!:\\(\\)]+)\";?");
        }
        LinkedList<String> result = null;
        String example = gloss.substring(idx);
        Matcher lineMatch = examplePattern.matcher(example);
        boolean i = false;
        while (lineMatch.find()) {
            String word = lineMatch.group(1);
            if (result == null) {
                result = new LinkedList<String>();
            }
            result.add(word);
        }
        return result;
    }

    public static String parseDescription(String gloss) {
        if (gloss == null) {
            return null;
        }
        int idx = -1;
        idx = gloss.indexOf(34);
        if (idx >= 0) {
            return gloss.substring(0, idx - 2);
        }
        return gloss;
    }

    public static void main(String[] args) throws FileNotFoundException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("rita.wordnet.WordnetUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.out.println(WordnetUtil.getResourceStream(clazz, "wdict.dat"));
    }
}

