
import sys
import commands
import os

cwd = os.getcwd()

dawg_str = sys.argv[1] 
landscape_str = sys.argv[2] 

try:
  mnl = int(sys.argv[3])
except:
  mnl = 1


dawg_filename = dawg_str + '.dot' 
tree_filename = dawg_str + '.tree' 
landscape_filename = landscape_str + '.landscape' 

print 'Building DAWG from ' + dawg_str
commands.getoutput('./bin/build_dawg %s %s'%(dawg_str, dawg_filename))
print 'Building TREE' 
commands.getoutput('./bin/build_tree %s %s'%(dawg_filename, tree_filename))
print 'Building LANDSCAPE for ' + landscape_str + ' w.r.t. ' + dawg_str
commands.getoutput('./bin/build_landscape %s %s %s %s > %s'%(dawg_filename, tree_filename, landscape_str, mnl, landscape_filename)) 
print 'Landscape stored in ' + landscape_filename

print 'Plotting...'
print 'Press Ctrl + C to kill'
try:
  commands.getoutput('python src/plotter.py ' + landscape_filename)
except KeyboardInterrupt:
  print 'DONE.'




