#!/usr/bin/python
import sys
import re

from Bio import SeqIO

prog_name, fasta_file, recognition_sequence, cut_offset = sys.argv

for record in SeqIO.parse(open(fasta_file, "rU"), "fasta"):
    sites = [m.start() + int(cut_offset) for m in re.finditer(recognition_sequence, str(record.seq))]
    if len(sites) > 0: 
        print record.id, len(record.seq), len(sites)
        print " ".join((str(s) for s in sites)) + " "
