// This file contains a significantly modified version of code found in 
// the sdsl-lite library, as such, the following applies:

/////////////////////////////////////////////////////////////////////////
// Copyright (C) 2007-2014 Simon Gog  All Right Reserved.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see http://www.gnu.org/licenses/ .
/////////////////////////////////////////////////////////////////////////


// The modifications are naturally also released under the GPL v3, to
// which the following applies:

/////////////////////////////////////////////////////////////////////////
// Copyright (C) 2014 Martin Muggli  All Right Reserved.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see http://www.gnu.org/licenses/ .
/////////////////////////////////////////////////////////////////////////


std::vector<std::vector<int> > offsets_stack;

int global_align;
// Assume the portion to the right of r has been matched
template<class t_csa, class t_pat_iter>
typename t_csa::size_type
mybs(
    const t_csa& csa,
    const t_pat_iter& begin, 
    t_pat_iter it, 
    typename t_csa::size_type l, 
    typename t_csa::size_type r, 
    std::vector<typename t_csa::char_type> & running_alignment, 
    std::vector<std::vector<typename t_csa::char_type> >& all_alignments,
    int accum_silico_len,
    int accum_opt_len,
    int opt_depth, // depth of the search, means the number of tokens we've matched (not counting skips) by the entry to this function
    int silico_depth,
    std::vector<std::vector<typename t_csa::char_type> >& hit_cache,
    unsigned &explored_count
    ) 

    
    {
        if (opt_depth > maxdepth) maxdepth = opt_depth;


        // consider skipping over this silico frag completely in case the corresponding optical frag  was lost in the optical mapping process
        if (*it < largest_maybe_frag) {

            // FIXME: this code is cut-n-pasted from below, turn this into a function before making further changes to this code!
            // if this is the last piece, then emit the alignment we have
                if (begin == it && opt_depth >= 1) {
                    all_alignments.push_back(running_alignment);

//                    if (running_alignment.size() > 1) {
                    int frag_extends_suffix = r + 1 - l;
            
                        for (int ii = 0 ; ii < frag_extends_suffix ; ++ii) {
                            //global_align = csa[newl + ii]; //force csa lookup even if we're not outputting anything
                            std::cout << "Aligned at optical frag " << /*csa[newl + ii] */ "(sa " << sa[l + ii] <<"). Locus " << optfrag2locus[sa[l + ii]] << "." << std::endl;
                            
                        }
//                    }

                    // float thresh = (abs((accum_silico_len + *it) - (accum_opt_len + *c)) / sqrt((depth + 1) * OM_STDDEV * OM_STDDEV)) ;
                    // if (thresh < minthreshold) minthreshold = thresh;

                    // else decrement the query symbol index and continue
                } else if (begin != it) {
                    mybs(csa, begin, it-1, l, r, running_alignment, all_alignments, accum_silico_len, accum_opt_len, opt_depth, silico_depth + 1 , hit_cache, explored_count);
                }

        }

        std::vector<typename t_csa::char_type> hits;
        if (1) { //(hit_cache.size() < depth + 1) {
  
            const sdsl::csa_wt<sdsl::wt_int<>, 64, 64, sdsl::sa_order_sa_sampling<>, 
                               sdsl::int_vector<>, 
                               sdsl::int_alphabet<>> * const 
                fm = dynamic_cast<const sdsl::csa_wt<sdsl::wt_int<>, 64, 64, sdsl::sa_order_sa_sampling<>, sdsl::int_vector<>, sdsl::int_alphabet<>> * const>(&csa);
            assert(fm != NULL);
            int min =  (*it) - search_radius;
            if (min < 0) min = 0;
            int max = (*it) + search_radius;
            typename t_csa::size_type lsearch = l > 1? l - 1: 0;
            typename t_csa::size_type rsearch = r < fm->wavelet_tree.size() ? r + 1 : fm->wavelet_tree.size();
            
            hits = restricted_unique_range_values(fm->wavelet_tree, /*l, fm->wavelet_tree.size(),*/ l, r, min, max);
//            std::cout << "(depth " << depth << ", hits " << hits.size() << ") ";
            hit_cache.push_back(hits);
             // std::cout << "populating hit cache for value "<< *it <<" depth " << depth << " :";
             // typename std::vector<typename t_csa::char_type>::iterator hits_end = hits.end();
             // typename std::vector<typename t_csa::char_type>::iterator c;
             // for (c = hits.begin(); c != hits_end; ++c) {
             //     std::cout << *c << " ";
             // }
             // std::cout << std::endl;
        }

//        std::vector<typename t_csa::char_type> &hits = hit_cache[depth];
        // if (hits.size() >= 1) {
        //     int k = 1;
        //     k++;
        //     std::cout <<  ( int)*it << " " << hits.size() << " (hit)" << std::endl;
        // } else {
        //     std::cout << ( int)*it << " " << hits.size()  << " (miss)" << std::endl;
        // }
        typename std::vector<typename t_csa::char_type>::iterator hits_end = hits.end();
        typename std::vector<typename t_csa::char_type>::iterator c;
        for (c = hits.begin(); c != hits_end; ++c) {
            typename t_csa::size_type newl;
            typename t_csa::size_type newr;

            explored_count++;
            float deviance =  (abs((accum_silico_len + *it) - (accum_opt_len + *c)) /   sqrt((opt_depth + 1) * OM_STDDEV * OM_STDDEV));
            bool frag_seq_matches =  deviance <= f_thresh  ; // SOMA eqn (1), evaluating whether a candidate would still allowed
            if (!frag_seq_matches) {
                //std::cout << "deviance: " << deviance << std::endl;
                continue;
            }

            sdsl::backward_search(csa, l, r, *c, newl, newr); // single character backward search
            int frag_extends_suffix = newr + 1 - newl;
            if (1) { //(frag_extends_suffix > 0) {

                running_alignment.push_back(*c);

                if (verbose) {
                    std::vector<int> offsets;
                    // first the silico fragment
                    offsets.push_back(*it); 
                    // then the candidate optical frag
                    offsets.push_back(*c);
                    for (int ii = 0 ; ii < frag_extends_suffix ; ++ii) {
                        offsets.push_back(optfrag2locus[csa[newl + ii]] );
                    }

                    offsets_stack.push_back(offsets);
                    for (std::vector<std::vector<int> >::iterator frame_it = offsets_stack.begin();  offsets_stack.end() != frame_it; ++frame_it) {
                        std::vector<int> &frame = *frame_it;
                        std::vector<int>::iterator val_it = frame.begin();
                        std::cout << "(silico " << *val_it;
                        ++val_it;
                        std::cout << " ~> optical " << *val_it;
                        ++val_it;
                        std::cout << ", @posns: {";
                        for(; val_it != frame.end(); ++val_it) {
                            std::cout << *val_it << " ";
                        }
                        std::cout << "})   ";

                    }
                    std::cout << std::endl; 
                }
                // for (typename std::vector<typename t_csa::char_type>::iterator runit = running_alignment.begin(); runit != running_alignment.end(); ++runit) {
                //     std::cout << *runit << "\t" ;
                // }
                // std::cout << std::endl;

                if (begin == it) {
                    all_alignments.push_back(running_alignment);

//                    if (running_alignment.size() > 1) {
                        for (int ii = 0 ; ii < frag_extends_suffix ; ++ii) {
                            //global_align = csa[newl + ii]; //force csa lookup even if we're not outputting anything
                            std::cout << "Aligned at optical frag " << /*csa[newl + ii] */ "(sa " << sa[newl + ii] <<"). Locus " << optfrag2locus[sa[newl + ii]] << "." << std::endl;
                            
                        }
//                    }

                    float thresh = (abs((accum_silico_len + *it) - (accum_opt_len + *c)) / sqrt((opt_depth + 1) * OM_STDDEV * OM_STDDEV)) ;
                    if (thresh < minthreshold) minthreshold = thresh;
//                    std::cout << "***" << std::endl;
                    // std::cout << "(aligned "<<running_alignment.size()<<" opt frags: ";
                    // //debugging print code
                    // typename std::vector<typename t_csa::char_type>::iterator rai = running_alignment.begin();
                    // typename std::vector<typename t_csa::char_type>::iterator raie = running_alignment.end();
                    // for (; rai != raie; ++rai) {
                    //     std::cout << *rai << ", ";
                    // }
                    // std::cout << ")" << std::endl;
                } else {
                    int child_accum_silico_len = accum_silico_len + *it; // need the pre-decrement version
                    // std::cout << "decrementing it (currently points to " << *it <<")" ;
                    // it--;
                    // std::cout << "(now " << *it << ")"<< std::endl;
                    mybs(csa, begin, it-1, newl, newr, running_alignment, all_alignments, child_accum_silico_len, accum_opt_len + *c, opt_depth + 1, silico_depth + 1, hit_cache, explored_count);
                    // std::cout << "incrementing it (currently points to " << *it <<")";
                    // it++;
                    // std::cout << "(now " << *it << ")"<< std::endl;
                }
                
                if (verbose) offsets_stack.pop_back();
                running_alignment.pop_back();
            } 


        }
    }


template<class t_csa, class t_pat_iter>
typename t_csa::size_type
my_backward_search(
    const t_csa& csa,
    typename t_csa::size_type l,
    typename t_csa::size_type r,
    t_pat_iter begin,
    t_pat_iter end,
    typename t_csa::size_type& l_res,
    typename t_csa::size_type& r_res,
    SDSL_UNUSED typename std::enable_if<std::is_same<sdsl::csa_tag, typename t_csa::index_category>::value, sdsl::csa_tag>::type x = sdsl::csa_tag()
)
{
    std::vector<typename t_csa::char_type>  running_alignment;

    std::vector<std::vector<typename t_csa::char_type> > hit_cache;
    
    std::vector<std::vector<typename t_csa::char_type> > all_alignments;
    unsigned explored_count = 0;
    t_pat_iter it = end;
    it--;


    mybs(csa, begin, it, l, r, running_alignment, all_alignments, 0, 0, 0, 0, hit_cache, explored_count);

    l_res = 0;
    r_res = all_alignments.size() - 1;
//    std::cout << "(explored " << explored_count << ")";
//    std::cout << std::endl;
    return all_alignments.size();
}







template<class t_csa, class t_pat_iter>
typename t_csa::size_type mycount(
    const t_csa& csa,
    t_pat_iter begin,
    t_pat_iter end,
    sdsl::csa_tag
)
{
    if (end - begin > (typename std::iterator_traits<t_pat_iter>::difference_type)csa.size())
        return 0;
    typename t_csa::size_type t=0; // dummy variable for the backward_search call
    typename t_csa::size_type result = my_backward_search(csa, 0, csa.size()-1, begin, end, t, t);
    return result;
}


// from sdsl-lite:
template<class t_csx, class t_pat_iter>
typename t_csx::size_type mycount1(
    const t_csx& csx,
    t_pat_iter begin,
    t_pat_iter end
)
{
    typename t_csx::index_category tag;
    return mycount(csx, begin, end,  tag);
}
