#!/usr/bin/python
import sys
import re

from Bio import SeqIO
import Bio.Restriction

prog_name, fasta_file, enzyme_name, out_fname = sys.argv

out_h = open(out_fname, "w")

for record in SeqIO.parse(open(fasta_file, "rU"), "fasta"):
    sites = [biosite - 1 for biosite in getattr(Bio.Restriction, enzyme_name).search(record.seq)]
    #sites = [m.start() + int(cut_offset) for m in re.finditer(recognition_sequence, str(record.seq))]
    if len(sites) > 1: 
        out_h.write(str(record.id) + " " + str(len(record.seq)) + " " + str(len(sites)) + "\n")
        out_h.write(" ".join((str(s) for s in sites)) + " \n")

out_h.close()

