#!/usr/bin/python
#usage infile outfile

import sys,re, struct
item = struct.Struct("i")

if len(sys.argv) < 4:
    print "Usage:", sys.argv[0], "<SOMA format optical map> <output file> <bin size> [is_prokaryote]"
    sys.exit(1)

bin_size = int(sys.argv[3])

binfile = open(sys.argv[2], "wb")

def quantize(val, bin_size):
    if val % bin_size < bin_size / 2.0: 
        new_val = val - val % bin_size
    else:
        new_val = val - val % bin_size +  bin_size
    return new_val

def add_frags(binfile, soma_optmap_file):
    for line in open(soma_optmap_file):
        parts = re.split(r"\s+", line.strip())
        val = int(float(parts[0]) * 1000)
        quantized_val = quantize(val, bin_size)

        binfile.write(item.pack(quantized_val))

add_frags(binfile, sys.argv[1])
if len(sys.argv) == 5:
    add_frags(binfile, sys.argv[1])

binfile.close()
