% Copyright (C) 1998 Charles W. Anderson

% Initialize the network.
%   This net has 2 inputs, 5 hidden units, and 1 output unit.
%   The learning rate for the hidden units is 5.0 and for the
%   output unit it is 2.0.  The momentum rate is 0.0.  The range of
%   initial weights values is -0.1 to 0.1;
net = nninit(2,5,1,5,2,0,0.1);

% data is matrix containing one row per training example.
%  First two columns are the two input components.
%  Third column is desired output, or target, for the example.
%  This data represents the two-bit exclusive-or.
dataTrain = [1 1 0.1; 1 0 0.9; 0 1 0.9; 0 0 0.1];
%  Make noisy versions for validation to determine best epoch.
dataValidate = dataTrain + randn(4,3)*0.1;
%  Make another noisy versions for testing data.
dataTest = dataTrain + randn(4,3)*0.1;

% Train the network with "early stopping".  Results returned in
% "net" structure.
net = nntrain(net,[dataTrain; dataValidate; dataTest],4,4,4,100);

% Plot the error curves.
%subplot(2,1,1);
xlabel('Epochs');
ylabel('RMS Error');
title('Error Curves');
x = 1:length(net.perftrain);
plot(x,net.perftrain,'r',x,net.perfvalidate,'b');
disp('Press any key...');
fflush(1);
pause;

% Also plot the target values and the actual network output for
% each testing example.
%subplot(2,1,2);
xlabel('Testing Examples');
ylabel('Target or Net Output');
title('Target and Actual Outputs');
plot(1:4,dataTest(:,3),'r',1:4,net.out,'g');
disp('Press any key...');
fflush(1);
pause;

% Plot the network output as a surface of the two-dimensional input
% space.
N = 10;
for x=1:N
  for y = 1:N
    net = nncalcout(net,[x/N y/N]);
    surf(x,y) = net.out;
  end
end
xlabel('Input 1');
ylabel('Input 2');
zlabel('Network Output');
title('Network Output Over Input Space');
mesh(1:N,1:N,surf);

