function net = nntrain(net,data,ntrain,nvalidate,ntest,nepochs)
%net =  nntrain(net,data,ntrain,nvalidate,ntest,nepochs)
% net generated by nninit.
% data: input-target patterns by rows, input in first columns, target in last
% ntrain: number of training patterns, in data(1:ntrain,:)
% nvalidate: num of validate patterns, in next nvalidate rows.
% ntest:     num of testing patterns, in next ntest rows.
% nepochs:   num of epochs to train
%
% net = nninit(2,5,1,5,2,0,0.1);
% d = [1 1 0.1; 1 0 0.9; 0 1 0.9; 0 0 0.1];
% net = nntrain(net,[d;d+randn(4,3)*0.1;d+randn(4,3)*0.1],4,4,4,1000);
% x = 1:length(net.perftrain);
% plot(x,net.perftrain,'r',x,net.perfvalidate,'b');

% Copyright (C) 1998 Charles W. Anderson

best = 0.;  %needed for octave

%net.perftrain = zeros(1,nepochs);

for ep = 1:nepochs
  net.epoch = net.epoch + 1;
  % Loop through training data, updating weights after each pattern.
  esum = 0.;
  for itr = 1:ntrain
    net = nnfp(net,data(itr,:));
    esum = esum + sum(net.error.^2);
    net = nnupdatewts(net);
  end
  net.perftrain(net.epoch) =sqrt(esum/ntrain/net.no);
  if round(ep/(nepochs/10)) == ep/(nepochs/10),  %mod(ep,nepochs/10)==0,
    fprintf(1,'Epoch %d RMS Error %f\n',ep,net.perftrain(ep));
    fflush(1);
  end
  
  % Do all validate data at once.  No loop needed.
  if nvalidate > 0
    % Early stopping:  remember best weights
    net = nnfp(net,data(ntrain+1 : ntrain+nvalidate, :));
    esum = sum(sum(net.error.^2));
    net.perfvalidate(ep) = sqrt(esum/nvalidate/net.no);
    if ep == 1 | net.perfvalidate(ep) < best
      best = net.perfvalidate(ep);
      bestnet.wh = net.wh;
      bestnet.wo = net.wo;
      net.epoch = ep;
    end
  end
  
end

% Now use best weights and calculate error on test set.
if nvalidate > 0
  net.wh = bestnet.wh;
  net.wo = bestnet.wo;
end
if ntest > 0
  net = nnfp(net,data(ntrain+nvalidate+1 : ntrain+nvalidate+ntest, :));
  esum = sum(sum(net.error.^2));
  net.perftest = sqrt(esum/ntest/net.no);
end

