function newPanel = addPanel(panelName, visible)
%panel = addPanel(panelName, index, visible)

userData = get(gcf,'UserData');
if isfield(userData,'panelList')
  panelList = userData.panelList;
else
  panelList = [];
end

set(gcf,'Units','character');
pos = get(gcf,'Position');
figwidth = pos(3);
figheight = pos(4);
%set(0,'Units','character');
%screen_s = get(0,'ScreenSize');
%figwidth = screen_s(3)-20;
%ffigheight = screen_s(4)-20;
width = figwidth-2;
height = figheight-5;

newPanel.name = panelName;
newPanel.nameNoBlanks = noblanks(panelName);

if isempty(panelList)
  newPanel.button = uicontrol('Style','pushbutton',...
      'Units','character',...
      'Position',[1 1+height-0.2 1.5*length(newPanel.name)+2 2],...
      'Tag',newPanel.nameNoBlanks,'String',newPanel.name,...
      'BackgroundColor',[0.7 0.7 0.7],...
      'FontSize',12,'FontWeight','Bold',...
      'Callback','makePanelVisible;');
  newPanel.panel = uipanel('Units','character',...
      'Position',[1 1 width height],...
      'Tag',['Panel' newPanel.nameNoBlanks],...
      'BackgroundColor',[0.7 0.7 0.7],'Visible',visible);
else
  prevPanel = panelList(end);
  button = prevPanel.button;
  %%panel = prevPanel.panel;

  newPanel.button = copyobj(button,gcf);
  pos = get(button,'Position');
  set(newPanel.button,'Tag',newPanel.nameNoBlanks,'String',newPanel.name,...
      'Position',[pos(1)+pos(3)+1 pos(2) 1.5*length(newPanel.name)+2 2],...
      'BackgroundColor',[0.7 0.7 0.7]);
  
  newPanel.panel = uipanel('Units','character',...
      'Position',[1 1 width height],...
      'Tag',['Panel' newPanel.nameNoBlanks],...
      'BackgroundColor',[0.7 0.7 0.7],'Visible',visible);
end


  
if strcmp(visible,'on')
  for p = panelList  
    set(p.button,'BackgroundColor',[0.7 0.7 0.7]);
    set(p.panel,'Visible','off');
  end
  set(newPanel.button,'BackgroundColor',[1 1 1]);
  set(newPanel.panel,'Visible','on');
end

panelList = [panelList newPanel];

userData.panelList = panelList;
set(gcf,'UserData',userData);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function result = noblanks(str)

result = str(~isspace(str));

