function [state,lastPosition] = channelVarsGUI(command,state,position,nChannels,parent)
%  [state,lastPosition] = channelVarsGUI(command,state,position,nChannels,parent)
%
%  command: 'init'  create GUI uicontrols
%           'destroy'  destroy all uicontrols, keep values
%           'read'  load state structure from current values in uicontrols
%  state: structure of feature parameters, and uicontrol handles
% position: [x y width height] area in characters for laying out uicontrols
% nChannels: number of channels being recorded
%  parent: panel uicontrol whose visibility controls visibility of 
%       uicontrols built here.
%
% state.channels = str2num(get(getobj('Tag','freqVarsChannelsTag'),'String'));
%      .windowSize = str2num(get(getobj('Tag','freqVarsWindowSizeTag'),'String'));
%      .windowShift = str2num(get(getobj('Tag','freqVarsWindowShiftTag'),'String'));
% lastPosition: lower right position of uicontrols layed out here.


if strcmp(command,'init')

  'in init'
  
  state.channelVars.handles = [];
  
  if isfield(state,'channelVars') && isfield(state.channelVars,'channels')
    nChannels = length(state.channelVars.channels);
    c = state.channelVars.channelsStr;
  else
    c = ['1:' num2str(nChannels)];
  end

  [hvalue,hlabel] = uiLabelEdit(position,parent,['Channels (1 to ' num2str(nChannels) ')'],...
      padString(c,2),'channelVarsChannelsTag','channelVarsChannelsLabelTag');
  state.channelVars.handles = [state.channelVars.handles hlabel hvalue];
  hfirst = hlabel; %for copying below

  pos=get(hfirst,'Position');

  if isfield(state,'channelVars') && isfield(state.channelVars,'windowSize')
    w = num2str(state.channelVars.windowSize);
  else
    w = '64';
  end
  [hvalue,hlabel] = uiLabelEdit([pos(1) pos(2)-3],parent,...
      'Window Size',padString(w,3),'channelVarsWindowSizeTag');
  state.channelVars.handles = [state.channelVars.handles hlabel hvalue];
  
  if isfield(state,'channelVars') && isfield(state.channelVars,'windowShift')
    wshift = num2str(state.channelVars.windowShift);
  else
    wshift = '32';
  end
  [hvalue,hlabel] = uiLabelEdit(hvalue,parent,'Window Shift',...
      padString(wshift,3),'channelVarsWindowShiftTag');
  state.channelVars.handles = [state.channelVars.handles hlabel hvalue];
  
  lastPosition = get(hvalue,'Position');
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(command,'destroy')
  
  if isfield(state,'channelVars') && isfield(state.channelVars,'handles')
    state = channelVarsGUI('read',state);
    for h = state.channelVars.handles
      delete(h);
    end
  end
  state.channelVars.handles = [];
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(command,'read')
  
  userData = get(gcf,'UserData');
  
  state.channelVars.channelsStr = depadString(get(findobj('Tag','channelVarsChannelsTag'),'String'));
  state.channelVars.channels = str2num(state.channelVars.channelsStr);
  state.channelVars.windowSize = str2num(get(findobj('Tag','channelVarsWindowSizeTag'),'String'));
  state.channelVars.windowShift = str2num(get(findobj('Tag','channelVarsWindowShiftTag'),'String'));

  state.numFeatures = length(state.channelVars.channels);
  channels = getUserData('channels');
  state.featureNames = channels.name(state.channelVars.channels);

  state.ranges = [-ones(state.numFeatures,1) ones(state.numFeatures,1)] * 75*75;

  state.secondsPerSample = state.channelVars.windowShift / userData.Fs;
end
