function panelClassifier(command,visible)
% panelClassifier('Create','on' or 'off') to add panel. Figure is created if not already.
% panelClassifier with no arguments also does this.

if nargin == 0 | strcmp(command,'Create')
  
  if nargin > 1
    v = visible;
  else
    v = 'off';
  end
  parent = addPanel('Classifier',v);
  parent = parent.panel;
  classifier.panel = parent;
  
  pos = get(parent,'Position');
  width = pos(3);
  height = pos(4);
  
  fs = textread('classifierFunctions.config','%s','delimiter',',');
  k = 0;
  for i = 1:3:length(fs)
    k = k + 1;
    classifier.methods.names{k} = fs{i};
    classifier.methods.functionsGUI{k} = fs{i+1};
    classifier.methods.functions{k} = fs{i+2};
  end
  
  h = uicontrol('Style','popup','String',classifier.methods.names,...
      'FontSize',12,'FontWeight','bold','Units','character',...
      'Parent',parent,'Position',[2,height-3,30,2],...
      'Callback','panelClassifier newMethod',...
      'Tag','classifierMethodTag');
  classifier.methodsMenu = h;
  setUserData('classifier',classifier);
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(command,'newMethod')

  classifier = getUserData('classifier');

  methodIndex = get(findobj('Tag','classifierMethodTag'),'Value');

  %delete previous uicontrol handles
  if isfield(classifier,'method')
    oldfunc = classifier.methods.functionsGUI{classifier.method};
    classifier = feval(oldfunc,'destroy',classifier);
  end

  func = classifier.methods.functionsGUI{methodIndex};
  channels = getUserData('channels');
  menuHandle = classifier.methodsMenu;
  fprintf(1,'Calling %s\n',func);
  p = get(menuHandle,'Position');
  p(1) = p(1) + p(3) + 1;
  classifier
  classifier = feval(func,'init',classifier,p(1:2),...
     length(channels.name),get(menuHandle,'Parent'));

 classifier.methodIndex = methodIndex;
 setUserData('classifier',classifier);

end
