function panelFeatures(command,visible)
% panelFeatures('Create','on' or 'off') to add panel. Figure is created if not already.
% panelFeatures with no arguments also does this.

global UseMindset;
global plotStackedScaledState;
global maxChannels;

if nargin == 0 | strcmp(command,'Create')
  
  if nargin > 1
    v = visible;
  else
    v = 'off';
  end
  parent = addPanel('Features',v);
  parent = parent.panel;
  features.panel = parent;
  
  pos = get(parent,'Position');
  width = pos(3);
  height = pos(4);
  
  fs = textread('featureFunctions.config','%s','delimiter',',');
  k = 0;
  for i = 1:3:length(fs)
    k = k + 1;
    features.methods.names{k} = fs{i};
    features.methods.functionsGUI{k} = fs{i+1};
    features.methods.functions{k} = fs{i+2};
  end

  h = uicontrol('Style','popup','String',features.methods.names,...
      'FontSize',12,'FontWeight','bold','Units','character',...
      'Parent',parent,'Position',[2,height-3,30,2],...
      'Callback','panelFeatures newMethod',...
      'Tag','featuresMethodTag');
  features.methodsMenu = h;

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','pushbutton','String','Start','FontSize',12,...
      'FontWeight','bold','Units','character',...
      'Parent',parent,'Position',[pos(1)+32,pos(2),10,2],...
      'Callback','panelFeatures Start','Tag','');

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'String','Stop','Position',[pos(1)+pos(3)+1 pos(2) pos(3:4)],...
	'Callback','panelFeatures Stop');

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','popup','String',{'EEG from Mindset','EEG Randomly Generated'},...
	'Value',1,'Tag','featuresSourceTag',...
	'Position',[pos(1)+20 pos(2) 30 2],'Callback','panelFeatures DataSource');
  UseMindset = 1;

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','popup','String',{'Do Not Filter Out Artifacts','Filter Out Artifacts'},...
	'Value',1,'Tag','UseFilter',...
	'Position',[pos(1)+30 pos(2) 30 2],'Callback','panelFeatures UseFilter');

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','popup','String',{'Unlimited Time','5 Seconds'},...
	'Value',1,'Tag','featuresMonitorTime',...
	'Position',[pos(1)+30 pos(2) 30 2],'Callback','panelFeatures TimeSpan');
  features.timeSpan = 0;

  setUserData('features',features);
     findobj('Tag','featuresMethodTag')
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(command,'newMethod')

  features = getUserData('features');

  methodIndex = get(findobj('Tag','featuresMethodTag'),'Value');

  %delete previous uicontrol handles
  if isfield(features,'method')
    oldfunc = features.methods.functionsGUI{features.method};
    features = feval(oldfunc,'destroy',features);
  end

  func = features.methods.functionsGUI{methodIndex};
  channels = getUserData('channels');
  menuHandle = features.methodsMenu;
  fprintf(1,'Calling %s\n',func);
  p = get(menuHandle,'Position');
  p(1) = p(1) + p(3) + 1;
  features
  features = feval(func,'init',features,[p(1) p(2)-3],...
     length(channels.name),get(menuHandle,'Parent'));

 features.methodIndex = methodIndex;
 setUserData('features',features);

     findobj('Tag','featuresMethodTag')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(command,'Start')
  
  randomEEG = get(findobj('Tag','featuresSourceTag'),'Value');
  Fs = 256;
  setUserData('Fs',Fs);

  if UseMindset
    mindinit;
    mindstart(Fs);
    pause(0.1);
  end

  features = getUserData('features');
  featureFuncGUI = features.methods.functionsGUI{features.methodIndex};
  featureFunc = features.methods.functions{features.methodIndex};
  features = feval(featureFuncGUI,'read',features)'

  panel = features.panel;

  o = findobj('Tag','featuresEEG');
  if ~isempty(o)
    delete(o);
  end
  pos = get(panel,'Position');
  width = pos(3);
  height = pos(4);

  ax = axes('XLim',[0 5],'Parent',panel,...
      'Units','character',...
      'Position',[pos(1)+width*0.1,pos(2)+height*0.1,width*0.8,height*0.7]);

  set(ax,'Tag','featuresEEG');

  plotstate.axes = ax;
  plotstate.labels = features.featureNames;
  plotstate.ranges = features.ranges;
  plotstate.secondsPerSample = features.secondsPerSample;
  plotstate.totalSeconds = 5;
  plotstate = plotTimeSeriesReset(plotstate);

  channels = getUserData('channels');
  nchannels = length(channels);

  recording = 1;
  setUserData('recording',1);
  
  %%global ZakAt;
  %%ZakAt = 1;

  nSamples = 0;
  seconds = 5;

  eegBuffer = [];

  firstTime = 1;
  while recording

    userData = get(gcf,'UserData');
    if UseMindset
      eeg = mindgetwindow(1/4); %1/4 so don't query too often

    else  
      eeg = randn(maxChannels,30)*15;
      pause(30.0/Fs);
    end

    eeg = eeg(channels.jack,:);

    eeg = filterOutArtifacts(eeg);
    eegBuffer = [eegBuffer eeg];

    [newSamples,eegBuffer] = feval(featureFunc,eegBuffer,features); 

    if ~isempty(newSamples)
      plotstate = plotTimeSeries(newSamples,plotstate);
    end

    nSamples = nSamples + size(eeg,2);

    userData = get(gcf,'UserData'); 
    recording = userData.recording;

    if features.timeSpan > 0 & nSamples >= seconds * Fs
      % stop after 5 seconds
      break;
    end
    
  end %while

  if UseMindset
    mindstop;
  end

  set(gcf,'UserData',userData);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
elseif strcmp(command,'UseFilter')

  if get(gcbo,'Value') == 2
    setUserData('useFilter',1);
  else
    setUserData('useFilter',0);      
  end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
elseif strcmp(command,'TimeSpan')

  features = getUserData('features');
  if get(gcbo,'Value') == 2
    features.timeSpan = 5;
  else
    features.timeSpan = 0; %means indefinitely
  end
  setUserData('features',features);
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
elseif strcmp(command,'Stop')

  setUserData('recording',0);
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
elseif strcmp(command,'DataSource')

  'in datasource callback'
    
  if get(gcbo,'Value') == 1
    UseMindset = 1;
  else
    UseMindset = 0;
  end

end
