function panelSomething(command,visible)
% panelSomething('Create') to add tasks panel. Figure is created if not already.
% panelSomething with no arguments also does this.

if nargin == 0 | strcmp(command,'Create')
  
  if nargin > 1
    v = visible;
  else
    v = 'off';
  end

  parent = addPanel('Something',v);
  parent = parent.panel;
  pos = get(parent,'Position');
  width = pos(3);
  height = pos(4);
  
  
  h = uicontrol('Style','pushbutton','String','Do Something','FontSize',12,...
		'FontWeight','bold','Units','character',...
		'Parent',parent,'Position',[2,height-3,20,2],...
		'Callback','panelSomething DoSomething');

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'String','DoSomethingElse','Position',[pos(1)+pos(3)+1 pos(2) 40 pos(4)],...
	'Callback','panelSomething DoSomethingElse');

  something.parameter1 = 0;
  something.parameter2 = 0;
        
elseif strcmp(command,'DoSomething')
    
  something = getUserData('something');
  fprintf(1,'Doing Something\n');
  something.did = 1;
  
elseif strcmp(command,'DoSomethingElse')
    
  something = getUserData('something');
  fprintf(1,'Doing Something Else\n');
  something.did = 2;  

end

setUserData('something',something);

