function panelTrain(command,visible)
% panelTrain('Create','on' or 'off') to add panel. Figure is created if not already.
% panelTrain with no arguments also does this.

global UseMindset maxChannels;
%%global plotStackedScaledState;

nTasks = 2; %make modifiable some day

if nargin == 0 | strcmp(command,'Create')
  
  if nargin > 1
    v = visible;
  else
    v = 'off';
  end
  parent = addPanel('Train',v);
  parent = parent.panel;
  train.panel = parent;
  
  pos = get(parent,'Position');
  width = pos(3);
  height = pos(4);
  
  h = uicontrol('Style','pushbutton','String','Start','FontSize',12,...
		'FontWeight','bold','Units','character',...
		'Parent',parent,'Position',[2,height-3,10,2],...
		'Callback','panelTrain Start');

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'String','Stop','Position',[pos(1)+pos(3)+1 pos(2) pos(3:4)],...
	'Callback','panelTrain Stop');

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','popup','String',{'EEG from Mindset','EEG Randomly Generated'},...
	'Value',2,'Tag','withoutmindsetTrain',...
	'Position',[pos(1)+pos(3) pos(2) 30 2],'Callback','panelTrain DataSource');
  UseMindset = 0;

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','popup','String',{'Do Not Filter Out Artifacts','Filter Out Artifacts'},...
	'Value',1,'Tag','UseFilterTrain',...
	'Position',[pos(1)+30 pos(2) 30 2],'Callback','panelTrain UseFilter');

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','edit','String','3',...
	'Tag','TrainRepetitions',...
	'Position',[pos(1)+pos(3)+1 pos(2) 10 2],'Callback','');

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','text','String','task repetitions',...
	'Tag','',...
	'Position',[pos(1)+pos(3)+1 pos(2)-0.5 20 2],'Callback','');

  %% classifierFileName = 'new.classifier';
  
  %% pos = get(h,'Position');
  %% makeFileButtons(parent, classifierFileName, 'classifierFileTag',...
  %%               pos(1)+pos(3)+1,pos(2)+0.5,...
  %%		  'panelTrain pickClassifierFile',...
  %%		  'panelTrain editClassifierFile',...
  %%	  'panelTrain loadClassifierFile');
  
  %%% Buttons and edit boxes for making classifier.
  
  pos = get(parent,'Position');
  width = pos(3);
  height = pos(4);
  
  h = uicontrol('Style','pushbutton','String','Train Classifier','FontSize',12,...
		'FontWeight','bold','Units','character',...
		'Parent',parent,'Position',[2,height-6,20,2],...
		'Callback','panelTrain TrainClassifier');


  %%% Now for buttons to use classifier.
  
  pos = get(parent,'Position');
  width = pos(3);
  height = pos(4);
  
  h = uicontrol('Style','pushbutton','String','Start Classifying','FontSize',12,...
		'FontWeight','bold','Units','character',...
		'Parent',parent,'Position',[2,height-9,20,2],...
		'Callback','panelTrain StartClassifying');

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'String','Stop Classifying','Position',[pos(1)+pos(3)+1 pos(2) pos(3:4)],...
	'Callback','panelTrain StopClassifying');

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','text','String','movement averaging (0-1)','Tag','',...
	'Position',[pos(1)+pos(3)+1 pos(2)-0.5 30 2],'Callback','');
  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','edit','String','0.9','Tag','TrainAvgRate',...
	'Position',[pos(1)+pos(3)+1 pos(2)+0.5 10 2],'Callback','');

  %% save button
  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','pushbutton','String','Save Session','Tag','',...
	'Position',[pos(1)+pos(3)+10 pos(2) 20 2],...
	'Callback','panelTrain TrainSave');

  setUserData('train',train);
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(command,'Start')
  
%  clear plotStackedScaledState;
  randomEEG = get(findobj('Tag','withoutmindsetTrain'),'Value');
  Fs = 256;
  setUserData('Fs',Fs);

  if UseMindset
    mindinit;
%    mindstart(Fs);
%    pause(0.1);
  end

  train = getUserData('train');

  panel = train.panel;
  if isempty(findobj('Tag','Trainaxes'))
    ax = axes('Parent',panel);
    set(ax,'Tag','Trainaxes');
  end
  
  
  channels = getUserData('channels');
  nchannels = length(channels.name);
  nSamples = 0;
  seconds = 5; % record 5 seconds per task

  nReps = str2num(get(findobj('Tag','TrainRepetitions'),'String'));
  samplesTrain = cell(nTasks,nReps);

  recording = 1;
  setUserData('recording',1);
  userData = get(gcf,'UserData');
    
  taskOrder = repmat(1:nTasks, 1,nReps);
  taskOrder = taskOrder(randperm(length(taskOrder)));
  taskCount = zeros(1,nTasks);

  axes(findobj('Tag','Trainaxes'));
  axis([0 1 0 1]);
  axis off;
  hold on;
  
  c = [0.2 0.5]; 
  radius = 0.1;
  coords1 = repmat(c,4,1) + [-1 -1; 1 -1; 1 1; -1 1]*radius;
  train.leftBox = fill(coords1(:,1),coords1(:,2),[0 0.8 0]);

  coords2 = repmat(c,5,1) + [-1 -1; 1 -1; 1 1; -1 1; -1 -1]*radius*1.5;
  train.outline{1} = line(coords2(:,1),coords2(:,2) ,'Color',[1 0 0],...
			  'LineWidth',10,'Visible','off');

  d = [0.8 0.5]; 
  radius = 0.1;  
  coords3 = repmat(d,4,1) + [-1 -1; 1 -1; 1 1; -1 1]*radius;
  train.rightBox = fill(coords3(:,1),coords3(:,2),[0 0.8 0]);

  coords4 = repmat(d,5,1) + [-1 -1; 1 -1; 1 1; -1 1; -1 -1]*radius*1.5;
  train.outline{2} = line(coords4(:,1),coords4(:,2) ,'Color',[1 0 0],...
			  'LineWidth',10,'Visible','off');

  d = [0.5 0.5]; 
  radius = 0.05;  
  coords5 = repmat(d,4,1) + [-1 -1; 1 -1; 1 1; -1 1]*radius;
  train.cursor = fill(coords5(:,1),coords5(:,2),'yellow');
  
  %text(0.2,0.5,tasks{task},'FontSize',50)
  
  for task = taskOrder
    taskCount(task) = taskCount(task)+1;

    set(train.outline{task},'Visible','on');
    pause(1);
    set(train.outline{task},'Visible','off');    

    %eegBuffer = [];

    samples = recordEEG(seconds,Fs,~UseMindset);
    samplesTrain{task,taskCount(task)} = samples(channels.jack,:);

    %%'size eeg is ', size(eeg)
    %%'size samples is', size(samples)
    
  end
  
  train.samplesTrain = samplesTrain;
  train.nTasks = nTasks;

  train.classifier = classifierTrain(samplesTrain)

  %set(gcf,'UserData',userData);
  
  setUserData('train',train);

  showDone;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(command,'TrainClassifier')

  userData = get(gcf,'UserData');
  if ~isfield(userData,'features') || ~isfield(userData,'classifier')
    error('You must specify features and classifier first.');
  end

  train = getUserData('train');
  features = getUserData('features');
  classifier = getUserData('classifier');
  
  featureFuncGUI = features.methods.functionsGUI{features.methodIndex};
  classifierFuncGUI = classifier.methods.functionsGUI{classifier.methodIndex};
  features = feval(featureFuncGUI,'read',features)'
  classifier = feval(classifierFuncGUI,'read',classifier);
  
  featureFunc = features.methods.functions{features.methodIndex};
  classifierFunc = classifier.methods.functions{classifier.methodIndex};

  [nTasks,nReps] = size(train.samplesTrain);

  featureValues = []; %cell(nTasks,nReps);
  classes = [];
  for task = 1:nTasks
    for rep = 1:nReps
      eeg = train.samplesTrain{task,rep};
      eeg = filterOutArtifacts(eeg);
      newFeatures = feval(featureFunc,eeg,features);
      featureValues = [featureValues newFeatures];
     % features{task,rep} = featurize(eeg,train);
     classes = [classes ones(1,size(newFeatures,2))*task];
    end
  end      

  classifier = feval(classifierFunc,featureValues,classifier,'train',classes);

  setUserData('classifier',classifier);
  setUserData('features',features);

  showDone;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(command,'StartClassifying')
  
global MindSetLastRead;

  userData = get(gcf,'UserData');
  if ~isfield(userData,'features') || ~isfield(userData,'classifier')
    error('You must specify features and classifier first.');
  end

  features = getUserData('features');
  classifier = getUserData('classifier');
  
  featureFunc = features.methods.functions{features.methodIndex};
  classifierFunc = classifier.methods.functions{classifier.methodIndex};

  %  clear plotStackedScaledState;

  randomEEG = get(findobj('Tag','withoutmindsetTrain'),'Value');
  Fs = getUserData('Fs');
  seconds = 5;
  nReps = 5;

  if UseMindset
    mindinit;
  end

  train = getUserData('train');

  panel = train.panel;
  if isempty(findobj('Tag','Trainaxes'))
    ax = axes('Parent',panel);
    set(ax,'Tag','Trainaxes');
  end
  
  channels = getUserData('channels');
  nchannels = length(channels.name);
  nSamples = 0;
  
  recording = 1;
  setUserData('recording',1);
  userData = get(gcf,'UserData');
    

  velocity = 0;
  avgRate = str2num(get(findobj('Tag','TrainAvgRate'),'String'));
  
  nTasks = train.nTasks;
  taskOrder = repmat(1:nTasks, 1,nReps);
  taskOrder = taskOrder(randperm(length(taskOrder)));
  taskCount = zeros(1,nTasks);

  % Save in train structure so it can be saved to file later.
  train.use.seconds = seconds;
  train.use.samples = cell(nTasks,nReps);
  train.use.cursor = [];
  
  for task = taskOrder
    taskCount(task) = taskCount(task)+1;

    %% Center the cursor
    xdata = get(train.cursor,'XData');
    r = (xdata(2)-xdata(1)) * 0.5;
    set(train.cursor,'XData',[0.5-r 0.5+r 0.5+r 0.5-r]);

    set(train.outline{task},'Visible','on');
    pause(1);
    set(train.outline{task},'Visible','off');    

    if UseMindset
      mindstart(Fs);
      pause(0.1);
MindSetLastRead = clock;

    end

  eegBuffer = [];
    nSamples = 0;
    while recording & (nSamples < seconds*Fs)

      if UseMindset

	%eeg = mindget
eeg = mindgetwindow(1/4); %1/4 so don't query mindset too fast
      else  
	eeg = randn(maxChannels,30)*15 + 10*task;
	pause(30.0/Fs);
	%eeg = geteegdata;
      end
      
      eeg = eeg(channels.jack,:);
      train.use.samples{task,taskCount(task)}(:,nSamples+1:nSamples+size(eeg,2)) ...
	  = eeg;
      nSamples = nSamples + size(eeg,2);

      eeg = filterOutArtifacts(eeg);
      eegBuffer = [eegBuffer eeg];


tic
      [newSamples,eegBuffer] = feval(featureFunc,eegBuffer,features); 

      %[newSamples,eegBuffer] = featurize(eegBuffer,train); %extract from buffer
      
      if ~isempty(newSamples)
	%class = classify(train.classifier,newSamples);
	class = feval(classifierFunc,newSamples,classifier);

toc
tic
'size of class'
	size(class)

	moveSize = 0.05;
	dxs = (class-1.5)/0.5 * moveSize;
	xdata = get(train.cursor,'XData');
	for dx = dxs
	  velocity = avgRate * velocity + (1-avgRate) * dx;
	  xdata = xdata + velocity;
	  if xdata(1) < 0.1
	    xdata = xdata + 0.1 - xdata(1);
	  elseif xdata(2) > 0.9
	    xdata = xdata - (xdata(2) - 0.9);
	  end
	  set(train.cursor,'XData',xdata);
	  train.use.cursor = [train.use.cursor; 0.5*(xdata(2)+xdata(1)) task];
	  drawnow;
	end
      end
    
'one move done'
toc
      userData = get(gcf,'UserData'); 
      recording = userData.recording;



      if ~recording
	break;
      end
      
    end %of one task
  
    if UseMindset
      mindstop;
    end

    if ~recording
      break
    end
  
  end

  setUserData('train',train);

  showDone;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
elseif strcmp(command,'UseFilter')

  if get(gcbo,'Value') == 2
    setUserData('useFilter',1);
  else
    setUserData('useFilter',0);      
  end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
elseif strcmp(command,'Stop')

  setUserData('recording',0);
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
elseif strcmp(command,'StopClassifying')

  setUserData('recording',0);
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
elseif strcmp(command,'DataSource')

  if get(gcbo,'Value') == 1
    UseMindset = 1;
  else
    UseMindset = 0;
  end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(command,'TrainSave')

  [f,p] = uiputfile('*.mat');
  filename = [p f];

  userData = get(gcf,'UserData');
  save(filename,'userData','-mat');

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function showDone()

t = text(0.35,0.2,'Done','FontSize',100,'FontWeight','bold');
pause(2);
beep;
pause(2);
delete(t);
