function plotStackedScaled(eeg,ax,Fs,channels)
% plotStackedScaled(eeg,ax,Fs,channels); 
%   or
% plotStackedScaled(eeg);
%  Second form assumes current plot exists and just adds eeg to it.
%
% Example:
%  d = randn(5,100);
%  ch = {'c1','c2','c3','c4','c5'};
%  ax = axes('XLim',[0 10]);
%  plotStackedScaled(d,ax,100,ch);
%  for i = 1:15
%    pause(1);
%    d = randn(5,100);
%    plotStackedScaled(d);
%   end
%  
%  Old Example:
% eeg = Info.experiment.data{Info.task,Info.trial}  / 363.63;
% Fs = Info.experiment.Fs;
% ax = Info.axes;
% channels = Info.experiment.channels;
% plotStackedScaled(ax,eeg,Fs,channels);

global plotStackedScaledState;

graymap = 0;

if nargin > 1
  plotStackedScaledState.reset = 1;
  if nargin > 3
%    channels = plotStackedScaledState.channels;
    plotStackedScaledState.channels = channels;
  else
    for i = 1:size(eeg,1)
      channels{i} = num2str(i);
    end
  end
else
  ax = plotStackedScaledState.axes;
  Fs = plotStackedScaledState.Fs;
    channels = plotStackedScaledState.channels;
end

[nChannels,nSamples] = size(eeg);

% reset plot if this set of samples will go off the right end
if ~plotStackedScaledState.reset
  a = axis;
  if plotStackedScaledState.totalSamples + nSamples ...
	> a(2) * plotStackedScaledState.Fs
    plotStackedScaledState.reset = 1;
  end
end


if plotStackedScaledState.reset
  mins = min(eeg,[],2);
  maxs = max(eeg,[],2);
  scales = 1 ./ (maxs-mins) * 0.8;
  sampleIndices = 1:nSamples;
  plotStackedScaledState.totalSamples = 0;
  cla;
%  if isfield(plotStackedScaledState,'textBounds')
%    for i=1:2
%      for j=1:nChannels
%        delete(plotStackedScaledState.textBounds{i,j})
%      end
%    end
%  end
  set(ax,'YLimMode','auto');
else
  ax = plotStackedScaledState.axes;
  Fs = plotStackedScaledState.Fs;
  mins = plotStackedScaledState.mins;
  maxs = plotStackedScaledState.maxs;
  scales = plotStackedScaledState.scales;
  sampleIndices = (1:nSamples) + plotStackedScaledState.totalSamples;
end

%eegScaled = (eeg - repmat(mins',1, nSamples)) .* repmat(scales',1,nSamples);
eegScaled = (eeg - repmat(mins,1, nSamples)) .* repmat(scales,1,nSamples);
eegYShifted = eegScaled + repmat([nChannels-1:-1:0]', 1,nSamples);

% Tag manipulation necessary because call to plot removes the axis tag.
%tag = get(ax,'Tag');
axes(ax);
hold on;
%%plot(sampleIndices/Fs,eegYShifted,'k','EraseMode','none');
%plot(sampleIndices/Fs,eegYShifted,'k');
%if graymap,
  plot(sampleIndices/Fs,eegYShifted,'k');
%end
%axis(axislim);
%set(ax,'Tag',tag);

if plotStackedScaledState.reset
  %axis tight;
  xlabel('Seconds');
  
  hold on;
  set(gca,'YTick',ones(1,nChannels)*0.5+(0:nChannels-1))
  set(gca,'YTickLabel',channels(nChannels:-1:1));
  set(gca,'FontSize',14,'FontWeight','bold');

  % Plot zero line
  zY = zeros(1,nChannels);
  zYScaled = (zY - mins') .* scales';
  zYShifted = zYScaled + [nChannels-1:-1:0];
  plot([zeros(1,nChannels); ones(1,nChannels)*nSamples/Fs],...
      repmat(zYShifted,2,1) ,'b:');

%  hold off;

  % Draw mins and maxs for each channel
  p = axis;
  x = - (p(2) - p(1)) * 0.05;
  y = p(3);
  height = p(4)-p(3);
  textBounds = cell(2,nChannels);
  for i=1:nChannels
    t = text(x,y + height/nChannels * (nChannels-i+0.9),...
	sprintf('%4.1f',maxs(i)));
    set(t,'Color','blue','FontSize',8);
    textBounds{1,i} = t;
    t = text(x,y + height/nChannels * (nChannels-i+0.1),...
	sprintf('%4.1f',mins(i)));
    set(t,'Color','blue','FontSize',8);
    textBounds{2,i} = t;
  end    
  plotStackedScaledState.textBounds = textBounds;
end

drawnow;
axis manual; %to keep same Y range and X range


plotStackedScaledState.totalSamples = ...
    plotStackedScaledState.totalSamples + nSamples;
plotStackedScaledState.mins = mins;
plotStackedScaledState.maxs = maxs;
plotStackedScaledState.scales = scales;
plotStackedScaledState.Fs = Fs;
plotStackedScaledState.channels = channels;
plotStackedScaledState.axes = ax;
plotStackedScaledState.reset = 0;
