function channels = readchannels(filename)
%  channels = readchannels(filename)
%  channels{1} is vector of channel indices
%          {2} is cell array of names
%          {3} is vector of row indices in resulting EEG matrix

fid = fopen(filename);

if fid == -1
  error('Could not open file %s\n', filename);
end

% file contains entries like
%  1 VEOG 1
%  5 F3 2 
%  channel on Mindset (1-16 or 1-24),  name,  row in resulting matrix

channelscell = textscan(fid,'%d %s %d');

fclose(fid);

channels.jack = channelscell{1};
channels.name = channelscell{2};
channels.row = channelscell{3};

