function [errs,sumerr,outputs] = testrtrlplots(isample,samplesperplot,...
    cycles,errs,outputs,sumerr,sample,net);
% called from testrtrl
% Collects errs every samplesperplot
% Collects last 100 samples of outputs every plot interval

%For plotting output
ii = mod(isample,samplesperplot)+1;
if samplesperplot > 100
  ii = ii - (samplesperplot-100);
end
  
if ii > 0
  if cycles == 1
    outputs(ii,:) = [net.output(end:-1:1) sample(net.ni+1:end) sample(net.ni:-1:1) ...
	  ];
  else
    outputs((ii-1)*cycles+[ii:ii+cycles-1],:) = ...
	[net.output(end:-1:1) ...
	  [ones(cycles-1,1)*nan; sample(end-net.no+1:end)] ...
	  repmat(sample(net.ni:-1:1),cycles,1)  ];
  end
end

%For plotting error
sumerr = sumerr + net.error * net.error;
if mod(isample,samplesperplot) == 0
  errs = [errs; isample sqrt(sumerr/net.no/samplesperplot)];
  sumerr=0;
  clf;
  subplot('position',[0.1 0.7 0.8 0.25]);
  plot(errs(:,1),errs(:,2));
  subplot('position',[0.1 0. 0.8 0.6]);
  plotoutputs(outputs,net.no,net.nu,0,1);        
  drawnow;
end
