function [state,lastPosition] = freqBandsGUI(command,state,position,nChannels,parent)
%  [state,lastPosition] = freqBandsGUI(command,state,position,nChannels,parent)
%
%  command: 'init'  create GUI uicontrols
%           'destroy'  destroy all uicontrols, keep values
%           'read'  load state structure from current values in uicontrols
%  state: structure of feature parameters, and uicontrol handles
% position: [x y width height] area in characters for laying out uicontrols
% nChannels: number of channels being recorded
%  parent: panel uicontrol whose visibility controls visibility of 
%       uicontrols built here.
%
% state.freqBands.: updated structure of parameter values
%      .channels = str2num(get(getobj('Tag','freqBandsChannelsTag'),'String'));
%      .freqRanges = str2num(get(getobj('Tag','freqBandsFreqRangesTag'),'String'));
%      .windowSize = str2num(get(getobj('Tag','freqBandsWindowSizeTag'),'String'));
%      .windowShift = str2num(get(getobj('Tag','freqBandsWindowShiftTag'),'String'));
% lastPosition: lower right position of uicontrols layed out here.

command

if strcmp(command,'init')

  state

  'in init'
  
  state.freqBands.handles = [];
  
  if isfield(state,'freqBands') && isfield(state.freqBands,'channels')
    nChannels = length(state.freqBands.channels);
    c = state.freqBands.channelsStr;
  else
    c = ['1:' num2str(nChannels)];
  end

  [hvalue,hlabel] = uiLabelEdit(position,parent,['Channels (1 to ' num2str(nChannels) ')'],...
      padString(c,2),'freqBandsChannelsTag','freqBandsChannelsLabelTag');
  state.freqBands.handles = [state.freqBands.handles hlabel hvalue];
  hfirst = hlabel; %for copying below

  if isfield(state,'freqBands') && isfield(state.freqBands,'freqRangesStr')
    freqs = num2str(state.freqBands.freqRangesStr);
  else
    freqs = '1:40';
  end

  [hvalue,hlabel] = uiLabelEdit(hvalue,parent,...
	'Frequency Ranges',padString(freqs,10),'freqBandsFreqRangesTag');
  state.freqBands.handles = [state.freqBands.handles hlabel hvalue];

  if isfield(state,'width')
    width = num2str(state.freqBands.width);
  else
    width = '5';
  end

  [hvalue,hlabel] = uiLabelEdit(hvalue,parent,...
				'Central Angular Freq (e.g. 5)',padString(width,2),...
				'freqBandsWidthTag');
  state.freqBands.handles = [state.freqBands.handles hlabel hvalue];

  pos=get(hfirst,'Position');

  if isfield(state,'freqBands') && isfield(state.freqBands,'windowSize')
    w = num2str(state.freqBands.windowSize);
  else
    w = '64';
  end
  [hvalue,hlabel] = uiLabelEdit([pos(1) pos(2)-3],parent,...
      'Window Size',padString(w,3),'freqBandsWindowSizeTag');
  state.freqBands.handles = [state.freqBands.handles hlabel hvalue];
  
  if isfield(state,'freqBands') && isfield(state.freqBands,'windowShift')
    wshift = num2str(state.freqBands.windowShift);
  else
    wshift = '32';
  end
  [hvalue,hlabel] = uiLabelEdit(hvalue,parent,'Window Shift',...
      padString(wshift,3),'freqBandsWindowShiftTag');
  state.freqBands.handles = [state.freqBands.handles hlabel hvalue];
  
  lastPosition = get(hvalue,'Position');
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(command,'destroy')
  
  if isfield(state,'freqBands') && isfield(state.freqBands,'handles')
    state = freqBandsGUI('read',state);
    for h = state.freqBands.handles
      delete(h);
    end
  end
  state.freqBands.handles = [];
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(command,'read')
  
  userData = get(gcf,'UserData');
  
  state.freqBands.channelsStr = depadString(get(findobj('Tag','freqBandsChannelsTag'),'String'));
  state.freqBands.channels = str2num(state.freqBands.channelsStr);
  state.freqBands.freqRangesStr = depadString(get(findobj('Tag','freqBandsFreqRangesTag'),'String'));
  state.freqBands.freqRanges = str2num(state.freqBands.freqRangesStr);
  state.freqBands.width = str2num(get(findobj('Tag','freqBandsWidthTag'),'String'));
  state.freqBands.windowSize = str2num(get(findobj('Tag','freqBandsWindowSizeTag'),'String'));
  state.freqBands.windowShift = str2num(get(findobj('Tag','freqBandsWindowShiftTag'),'String'));
  state.numFeatures = length(state.freqBands.channels)...
      * length(state.freqBands.freqRanges)/2;

  channels = getUserData('channels');
  k = 0;
  ranges = state.freqBands.freqRanges;
  for fb = 1:2:length(ranges)
    for c = 1:length(state.freqBands.channels)
      k = k + 1;
      state.featureNames{k} = [num2str(ranges(fb)) '-' num2str(ranges(fb+1)) ...
	    ' Hz ' channels.name{state.freqBands.channels(c)}];
    end
  end
  state.ranges = [-ones(state.numFeatures,1) ones(state.numFeatures,1)] * 20;
  state.secondsPerSample = state.freqBands.windowShift / userData.Fs;
end
