function makePanelVisible(nameOptional)
% makePanelVisible(name) % without argument uses gcbo

panelList = getUserData('panelList');

if nargin == 0
  panel = findPanel(panelList,gcbo);
else
  panel = findPanel(panelList,nameOptional);
end
hideAll(panelList);
expose(panel);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function panel = findPanel(panelList,obj)
for p = panelList
  if (ischar(obj) && strcmp(obj,p.name)) || ...
	(isnumeric(obj) && obj == p.button)
     panel = p;
    return;
  else
    panel = [];
  end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function hideAll(panelList)
for p = panelList
  set(p.button,'BackgroundColor',[0.7 0.7 0.7]);
  set(p.panel,'Visible','off');
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function expose(panel)
set(panel.button,'BackgroundColor',[1 1 1]);
set(panel.panel,'Visible','on');

