function [state,lastPosition] = originalEEGGUI(command,state,position,nChannels,parent)
%  [state,lastPosition] = originalEEGGUI(command,state,position,nChannels,parent)
%
%  command: 'init'  create GUI uicontrols
%           'destroy'  destroy all uicontrols, keep values
%           'read'  load state structure from current values in uicontrols
%  state: structure of feature parameters, and uicontrol handles
% position: [x y width height] area in characters for laying out uicontrols
% nChannels: number of channels being recorded
%  parent: panel uicontrol whose visibility controls visibility of 
%       uicontrols built here.
%
% state.channels = str2num(get(getobj('Tag','freqVarsChannelsTag'),'String'));
% lastPosition: lower right position of uicontrols layed out here.


if strcmp(command,'init')

  'in init'
  
  state.originalEEG.handles = [];
  
  if isfield(state,'originalEEG') && isfield(state.originalEEG,'channels')
    nChannels = length(state.originalEEG.channels);
    c = state.originalEEG.channelsStr;
  else
    c = ['1:' num2str(nChannels)];
  end

  [hvalue,hlabel] = uiLabelEdit(position,parent,['Channels (1 to ' num2str(nChannels) ')'],...
      padString(c,2),'originalEEGChannelsTag','originalEEGChannelsLabelTag');
  state.originalEEG.handles = [state.originalEEG.handles hlabel hvalue];
  hfirst = hlabel; %for copying below

  pos=get(hfirst,'Position');

  lastPosition = get(hvalue,'Position');
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(command,'destroy')
  
  if isfield(state,'originalEEG') && isfield(state.originalEEG,'handles')
    state = originalEEGGUI('read',state);
    for h = state.originalEEG.handles
      delete(h);
    end
  end
  state.originalEEG.handles = [];
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(command,'read')
  
  userData = get(gcf,'UserData');
  
  state.originalEEG.channelsStr = depadString(get(findobj('Tag','originalEEGChannelsTag'),'String'));
  state.originalEEG.channels = str2num(state.originalEEG.channelsStr);

  state.numFeatures = length(state.originalEEG.channels);
  channels = getUserData('channels');
  state.featureNames = channels.name(state.originalEEG.channels);
  state.ranges = [-ones(state.numFeatures,1) ones(state.numFeatures,1)] * 75;
  state.secondsPerSample = 1 / userData.Fs;  
end
