function panelArtifacts(command,visible)
% panelArtifacts('Create','on' or 'off') to add artifact panel. Figure is created if not already.
% panelArtifact with no arguments also does this.

global plotStackedScaledState;

if nargin == 0 | strcmp(command,'Create')
  
  if nargin > 1
    v = visible;
  else
    v = 'off';
  end
  parent = addPanel('Artifacts',v);
  parent = parent.panel;
  artifacts.panel = parent;
  
  pos = get(parent,'Position');
  width = pos(3);
  height = pos(4);
  
  h = uicontrol('Style','text','String','Show Components (max 0)','FontSize',12,...
		'FontWeight','bold','Units','character',...
		'Parent',parent,'Position',[2,height-3.5,30,2],'Tag','FilterMaxComponents');

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','edit','String','1:6','Position',[pos(1)+pos(3)+1 pos(2)+0.5 pos(3:4)],...
	'Callback','panelArtifacts ShowComponents','Tag','FilterShowComponents');

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','text','String','Remove Components','Position',...
	[pos(1)+pos(3)+1 pos(2)-0.5 25 pos(4)],'Callback','','Tag','');

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','edit','String','1','Position',[pos(1)+pos(3)+1 pos(2)+0.5 pos(3:4)],...
	'Callback','panelArtifacts RemoveComponents','Tag','FilterRemoveComponents');

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','text','String','Lags','Position',...
	[pos(1)+pos(3)+1 pos(2)-0.5 6 pos(4)],'Callback','','Tag','');

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','edit','String','0','Position',[pos(1)+pos(3)+1 pos(2)+0.5 10 pos(4)],...
	'Callback','panelArtifacts ShowComponents','Tag','FilterLags');

  setUserData('artifacts',artifacts);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(command,'ShowComponents')
    
  artifacts = getUserData('artifacts');
    
  clear plotStackedScaledState;

  %% Update max num components string
  channels = getUserData('channels');
  nc = size(channels.jack,1);
  nlags = str2num(get(findobj('Tag','FilterLags'),'String'));
  maxc = (nlags+1)*nc;
  artifacts.maxComponents = maxc;
  set(findobj('Tag','FilterMaxComponents'),'String',...
		    ['Show Components (max ',num2str(maxc),')']);

  userData = get(gcf,'UserData');
  if isfield(userData,'eeg')

    showComponents = str2num(get(findobj('Tag','FilterShowComponents'),'String'));

    eeg = getUserData('eeg');
    eeglagged = lagize(eeg,nlags);
    size(eeglagged)
    % Calculate Max Noise Fraction Decomposition
    [phi,psi] = mnf(eeglagged);
    %phi = flipud(phi);

    % Names of components, just 1:nchannels
    ncomps = length(showComponents);
    fprintf(1,'%d Components\n',ncomps);
    compnames = cell(1,ncomps);
    for i = 1:ncomps
      compnames{i} = num2str(showComponents(i));
    end

    % Plot MNF components
    if isempty(findobj('Tag','FilterAxes'))
      ax = axes('XLim',[0 5],'Parent',artifacts.panel,'Tag','FilterAxes');
    end
    ax = findobj('Tag','FilterAxes');
    plotStackedScaled(phi(showComponents,:),ax,userData.Fs,compnames);
    
  end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(command,'RemoveComponents')
    
  nlags = str2num(get(findobj('Tag','FilterLags'),'String'));
  userData = get(gcf,'UserData');
  if isfield(userData,'eeg')
    eeg = getUserData('eeg');
    artifacts = getUserData('artifacts');

    eeglagged = lagize(eeg,nlags);
    % Calculate Max Noise Fraction Decomposition
    means = mean(eeglagged,2);
    [phi,psi] = mnf(eeglagged-repmat(means,1,size(eeglagged,2)));

    remove = str2num(get(findobj('Tag','FilterRemoveComponents'), ...
			 'String'));
    ncomponents = size(eeglagged,1);
    z = ones(1,ncomponents);
    z(remove) = 0;

    selector = diag(z);
    artifacts.filter = inv(psi) * selector * psi;
    artifacts.filterMeans = means;

    setUserData('artifacts',artifacts);
  end

end
