function panelChannels(command,visible)
% panelChannels('Create','on' or 'off') to add channels panel. Figure is created if not already.
% panelChannels with no arguments also does this.

global maxChannels;
maxChannels = 16; %set to 24 for new Mindset

if nargin == 0 | strcmp(command,'Create')
  
  channelfilename = 'channels.config';
  channelfileTag = 'channelfileTag';

  if nargin > 1
    v = visible;
  else
    v = 'off';
  end
  parent = addPanel('Channels',v);
  parent = parent.panel;
  channels.panel = parent;
  
  pos = get(parent,'Position');
  width = pos(3);
  height = pos(4);
  
  %%taskHandles = zeros(1,maxTasks);
  makeFileButtons(parent,channelfilename,channelfileTag,...
      2, height-3.5,...
      'panelChannels pickchannelfile;',...
      'panelChannels editchannelfile;',...
      'panelChannels loadchannelfile;');
  channels.filenameTag = channelfileTag;
  channels.filename = channelfilename;

  if exist(channelfilename,'file')
    jackNameRow = readchannels(channelfilename);
    channels.jack = jackNameRow.jack;
    channels.name = jackNameRow.name;
    channels.row = jackNameRow.row;
    setUserData('channels',channels);
    displayChannels();
    displayImpedances();
  end

  channels.maxChannels = maxChannels;
  setUserData('channels',channels);
  
elseif strcmp(command,'pickchannelfile')
  
  channels = getUserData('channels');

  [f,p] = uigetfile('*.config');
  channelfilename = [p f];

  set(findobj('Tag',channels.filenameTag),'String',f);
  channels.filename = channelfilename;
  jackNameRow = readchannels(channelfilename)
  channels.jack = jackNameRow.jack;
  channels.name = jackNameRow.name;
  channels.row = jackNameRow.row;
  
  setUserData('channels',channels);
  displayChannels();
  displayImpedances();
  
elseif strcmp(command,'editchannelfile')
  
  channels = getUserData('channels');
  edit(channels.filename);
  setUserData('channels',channels);
  
elseif strcmp(command,'loadchannelfile')
  
  channels = getUserData('channels');
  channelfilename = channels.filename;
  jackNameRow = readchannels(channelfilename);
  channels.jack = jackNameRow.jack;
  channels.name = jackNameRow.name;
  channels.row = jackNameRow.row;
  setUserData('channels',channels);
  displayChannels();
  displayImpedances();
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% displayChannels

function displayChannels()

global maxChannels;

channels = getUserData('channels');
panel = channels.panel;

if ~isfield(channels,'channelHandles')
  %make the uicontrols
  channelHandles = zeros(2,maxChannels);

  %Labels
  pos = get(panel,'Position');
  h = uicontrol('Style','text','String','Jack','FontSize',12,'Units','character',...
                'HorizontalAlignment','right','FontWeight','bold',...
                'Parent',panel,'Position',[2 pos(4)-10 15 2]);
  h = copyobj(h,panel);
  pos = get(h,'Position');
  set(h,'String','Electrode',...
        'Position',[pos(1) pos(2)-pos(4)-1 pos(3:4)]);
  h = copyobj(h,panel);
  pos = get(h,'Position');
  set(h,'String','Matrix Row',...
        'Position',[pos(1) pos(2)-pos(4)-1 pos(3:4)]);
  h = copyobj(h,panel);
  pos = get(h,'Position');
  set(h,'String','Impedance 1',...
        'Position',[pos(1) pos(2)-pos(4)-1 pos(3:4)]);
  h = copyobj(h,panel);
  pos = get(h,'Position');
  set(h,'String','Impedance 2',...
        'Position',[pos(1) pos(2)-pos(4)-1 pos(3:4)]);

  %Row of jack numbers
  pos = get(panel,'Position');
  h1 = uicontrol('Style','text',...
                 'String','1',...
                 'FontSize',12,...
                 'Units','character','HorizontalAlignment','center',...
                 'Position',[2+15+1 pos(4)-10 8 2],'Parent',panel);
  h = h1;
  for c = 2:maxChannels
    h = copyobj(h,panel);
    pos = get(h,'Position');
    set(h,'String',num2str(c),'Position',[pos(1)+pos(3)+1 pos(2:4)]);
  end

  %Row of electrode names
  h = h1;
  for c = 1:maxChannels
    h = copyobj(h,panel);
    channelHandles(1,c) = h;
    pos = get(h,'Position');
    if c == 1
      h1 = h;
      set(h,'Position',[pos(1) pos(2)-pos(4)-1 pos(3:4)]);
    else
      set(h,'Position',[pos(1)+pos(3)+1 pos(2:4)]);
    end
    ch = find(channels.jack == c);
    if isempty(ch)
      set(h,'String',' ');
    else
      set(h,'String',channels.name{ch});
    end
  end

  %Row of matrix row indices
  h = h1;
  for c = 1:maxChannels
    h = copyobj(h,panel);
    channelHandles(2,c) = h;
    pos = get(h,'Position');
    if c == 1
      h1 = h;
      set(h,'Position',[pos(1) pos(2)-pos(4)-1 pos(3:4)]);
    else
      set(h,'Position',[pos(1)+pos(3)+1 pos(2:4)]);
    end
    ch = find(channels.jack == c);
    if isempty(ch)
      set(h,'String',' ');
    else
      set(h,'String',num2str(channels.row(ch)));
    end
  end

  %% Row of Impedance 1
  nImpedances = 2;
  impedanceHandles = zeros(nImpedances,maxChannels);
  
  h = h1;
  for c = 1:maxChannels
    h = copyobj(h,panel);
    impedanceHandles(1,c) = h;
    pos = get(h,'Position');
    if c == 1
      h1 = h;
      set(h,'Position',[pos(1) pos(2)-pos(4)-1 pos(3:4)]);
    else
      set(h,'Position',[pos(1)+pos(3)+1 pos(2:4)]);
    end
    set(h,'Style','edit','String','0','HorizontalAlignment','center','Visible','off');
  end

  h = h1;
  for c = 1:maxChannels
    h = copyobj(h,panel);
    impedanceHandles(2,c) = h;
    pos = get(h,'Position');
    if c == 1
      h1 = h;
      set(h,'Position',[pos(1) pos(2)-pos(4)-1 pos(3:4)]);
    else
      set(h,'Position',[pos(1)+pos(3)+1 pos(2:4)]);
    end
    set(h,'Style','edit','String','0','HorizontalAlignment','center','Visible','off');
  end

  channels.channelHandles = channelHandles;
  channels.impedanceHandles = impedanceHandles;

else
  % set the strings
  channelHandles = channels.channelHandles;
  
  for c = 1:maxChannels
    ch = find(channels.jack == c);

    h = channelHandles(1,c);
    if isempty(ch)
      set(channelHandles(1,c),'String',' ');
      set(channelHandles(2,c),'String',' ');
    else
      set(channelHandles(1,c),'String',channels.name{ch});
      set(channelHandles(2,c),'String',num2str(channels.row(ch)));
    end
  end

end

setUserData('channels',channels);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% displayImpedances

function displayImpedances()
     global maxChannels;

channels = getUserData('channels');

impedanceHandles = channels.impedanceHandles;

%set visible impedances
for c = 1:maxChannels
  if find(channels.jack == c)
    set(impedanceHandles(1,c),'Visible','on');
    set(impedanceHandles(2,c),'Visible','on');
  else
    set(impedanceHandles(1,c),'Visible','off');
    set(impedanceHandles(2,c),'Visible','off');
  end
end      
