function panelMonitor(command,visible)
% panelMonitor('Create','on' or 'off') to add monitor panel. Figure is created if not already.
% panelMonitor with no arguments also does this.

global UseMindset;
global plotStackedScaledState;

if nargin == 0 | strcmp(command,'Create')
  
  if nargin > 1
    v = visible;
  else
    v = 'off';
  end
  parent = addPanel('Monitor',v);
  parent = parent.panel;
  monitor.panel = parent;
  
  pos = get(parent,'Position');
  width = pos(3);
  height = pos(4);
  
  h = uicontrol('Style','pushbutton','String','Start','FontSize',12,...
		'FontWeight','bold','Units','character',...
		'Parent',parent,'Position',[2,height-3,10,2],...
		'Callback','panelMonitor Start');

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'String','Stop','Position',[pos(1)+pos(3)+1 pos(2) pos(3:4)],...
	'Callback','panelMonitor Stop');

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','popup','String',{'EEG from Mindset','EEG Randomly Generated'},...
	'Value',2,'Tag','withoutmindset',...
	'Position',[pos(1)+20 pos(2) 30 2],'Callback','panelMonitor DataSource');
  UseMindset = 0;

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','popup','String',{'Do Not Filter Out Artifacts','Filter Out Artifacts'},...
	'Value',1,'Tag','UseFilter',...
	'Position',[pos(1)+30 pos(2) 30 2],'Callback','panelMonitor UseFilter');

  h = copyobj(h,parent);
  pos = get(h,'Position');
  set(h,'Style','popup','String',{'Unlimited Time','5 Seconds'},...
	'Value',1,'Tag','MonitorTime',...
	'Position',[pos(1)+30 pos(2) 30 2],'Callback','panelMonitor TimeSpan');
  monitor.timeSpan = 0;

  setUserData('monitor',monitor);
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(command,'Start')
  
  clear plotStackedScaledState;

  Fs = 256;
  setUserData('Fs',Fs);

  if UseMindset
    mindinit;
    mindstart(Fs);
    pause(0.1);
  end

  monitor = getUserData('monitor');
  panel = monitor.panel;
  %o = findobj('Tag','monitorEEG');
  %if ~isempty(o)
  %  delete(o);
  %end
  ax = axes('XLim',[0 5],'Parent',panel);
  set(ax,'Tag','monitorEEG');

  channels = getUserData('channels');
  nchannels = length(channels.name);
  nSamples = 0;
  seconds = 5; % save last 5 seconds (one screenful) for use with Filter
  eeg = zeros(nchannels,Fs*seconds);

  recording = 1;
  setUserData('recording',1);
    
  %%global ZakAt;
  %%ZakAt = 1;

  while recording

    userData = get(gcf,'UserData');
    if UseMindset
      e = mindget;
    else  
      e = randn(userData.channels.maxChannels,30)*15;
      pause(30.0/Fs);
      %e = geteegdata;
    end

    e = e(channels.jack,:);
    if monitor.timeSpan > 0 & nSamples+size(e,2) > size(eeg,2)
      % stop after 5 seconds
      %	if nSamples+size(e,2) > size(eeg,2)
      e = e(:,1:size(eeg,2)-nSamples);
      last = size(eeg,2);
      eeg(:,nSamples+1:last) = e;
      %	end
    else
      last = nSamples+size(e,2);
      eeg(:,nSamples+1:last) = e;
    end


    %% Filter data if filter created.
    if isfield(userData,'artifacts') & isfield(userData,'useFilter') ...
	  & userData.useFilter
      artifacts = getUserData('artifacts');
      nlags = str2num(get(findobj('Tag','FilterLags'),'String'));
      elagged = lagize(e,nlags);
      elaggedCentered = elagged - repmat(artifacts.filterMeans,1,size(elagged,2));
      filtered = artifacts.filter * elaggedCentered;
      e = filtered(1:size(e,1),:);
      fprintf(1,'Filtered\n');
    end
      
    if nSamples == 0
      plotStackedScaled(e,ax,Fs,channels.name);
    else
      plotStackedScaled(e);
    end

    nSamples = nSamples + size(e,2);

    %pause(0.08);drawnow;
    userData = get(gcf,'UserData'); 
    recording = userData.recording;
    userData.eeg = eeg;

    if monitor.timeSpan > 0 & nSamples >= size(eeg,2)
      % stop after 5 seconds
      break;
    end
      
  end %while

  if UseMindset
    mindstop;
  end

  set(gcf,'UserData',userData);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
elseif strcmp(command,'UseFilter')

  if get(gcbo,'Value') == 2
    setUserData('useFilter',1);
  else
    setUserData('useFilter',0);      
  end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
elseif strcmp(command,'TimeSpan')

  monitor = getUserData('monitor');
  if get(gcbo,'Value') == 2
    monitor.timeSpan = 5;
  else
    monitor.timeSpan = 0; %means indefinitely
  end
  setUserData('monitor',monitor);
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
elseif strcmp(command,'Stop')

  setUserData('recording',0);
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
elseif strcmp(command,'DataSource')

  if get(gcbo,'Value') == 1
    UseMindset = 1;
  else
    UseMindset = 0;
  end

end
