function state = plotTimeSeries(data,state)
% state = plotTimeSeries(data,state)
%   data   nComponents x nSamples
%   state.axes   axes
%        .labels cell array (1 x nComponents) of strings for each component
%        .ranges matrix (nComponents x 2)  min, max each row
%        .lastx  x axis value for last plotted point (in seconds)
%        .lasty  nComponents x 1  last y values
%        .secondsPerSample  
%        .totalSeconds  width of plot in seconds
%
%  Example:
%   state.axes = axes;
%   state.labels = {'C3','Cz','C4'};
%   state.ranges = [-1 1; -1 1; -1 1];
%   state.secondsPerSample = 1/8.;
%   state.totalSeconds = 5;
%   state = plotTimeSeriesReset(state);
%   for i = 1:10
%      data = randn(3,8);
%      state = plotTimeSeries(data,state)
%   end


axes(state.axes);

hold on;

[nComponents,nSamples] = size(data);

% reset plot if this set of samples will go off the right end
if state.reset || (isfield(state,'lastx') && state.lastx + nSamples*state.secondsPerSample > state.totalSeconds)
  set(gca,'XLim',[0 state.totalSeconds]);
  state.lastx = 0;
  drawLabels = 1;
  cla;
else
  drawLabels = 0;
end

state.reset = 0;

mins = state.ranges(:,1);
maxs = state.ranges(:,2);
%scales = 0.8 * 1 ./ (maxs-mins);
scales =  1 ./ (maxs-mins);

dataScaled = (data - repmat(mins,1, nSamples)) .* repmat(scales,1,nSamples);
dataShifted = dataScaled + repmat([nComponents-1:-1:0]', 1,nSamples);

state.lastx
times = (1:nSamples)* state.secondsPerSample + state.lastx;

if state.lastx > 0
  plot([state.lastx times],[state.lasty dataShifted]');
else
  plot(times,dataShifted');
end

state.lastx = times(end);
state.lasty = dataShifted(:,end);

if drawLabels
  xlabel('Seconds');
  set(gca,'YLimMode','auto');
  set(gca,'YTick',ones(1,nComponents)*0.5+(0:nComponents-1))
  set(gca,'YTickLabel',state.labels(nComponents:-1:1));
  set(gca,'FontSize',14,'FontWeight','bold');

  % Plot zero line
  zY = zeros(1,nComponents);
  zYScaled = (zY - mins') .* scales';
  zYShifted = zYScaled + [nComponents-1:-1:0];
  plot([zeros(1,nComponents); ones(1,nComponents)*state.totalSeconds],...
      repmat(zYShifted,2,1) ,'b:');

  % Draw mins and maxs for each channel
  p = axis;
  x = - (p(2) - p(1)) * 0.05;
  y = p(3);
  height = p(4)-p(3);
  textBounds = cell(2,nComponents);
  for i=1:nComponents
    t = text(x,y + height/nComponents * (nComponents-i+0.9),...
	sprintf('%4.1f',maxs(i)));
    set(t,'Color','blue','FontSize',8);
    t = text(x,y + height/nComponents * (nComponents-i+0.1),...
	sprintf('%4.1f',mins(i)));
    set(t,'Color','blue','FontSize',8);
  end    
end

drawnow;
axis manual; %to keep same Y range and X range

