function [state,lastPosition] = svdVecsGUI(command,state,position,nChannels,parent)
%  [state,lastPosition] = svdVecsGUI(command,state,position,nChannels,parent)
%
%  command: 'init'  create GUI uicontrols
%           'destroy'  destroy all uicontrols, keep values
%           'read'  load state structure from current values in uicontrols
%  state: structure of feature parameters, and uicontrol handles
% position: [x y width height] area in characters for laying out uicontrols
% nChannels: number of channels being recorded
%  parent: panel uicontrol whose visibility controls visibility of 
%       uicontrols built here.
%
% state: updated structure of parameter values
%      .channelsStr
%      .channels 
%      .lags   (0 for none)
%      .vectorIndicesStr
%      .vectorIndices
%      .windowSize
%      .windowShift
% lastPosition: lower right position of uicontrols layed out here.

command

if strcmp(command,'init')

  'in init'
  
  %handles deleted or not created yet.
  state.svdVecs.handles = [];
  
  if isfield(state,'svdVecs') && isfield(state.svdVecs,'channels')
    nChannels = length(state.svdVecs.channels);
    c = state.svdVecs.channelsStr;
  else
    c = ['1:' num2str(nChannels)];
  end

  [hvalue,hlabel] = uiLabelEdit(position,parent,['Channels (1 to ' num2str(nChannels) ')'],...
      padString(c,2),'svdVecsChannelsTag','svdVecsChannelsLabelTag');
  state.svdVecs.handles = [state.svdVecs.handles hlabel hvalue];
  hfirst = hlabel; %for copying below

  if isfield(state,'svdVecs') && isfield(state.svdVecs,'lags')
    lags = num2str(state.svdVecs.lags);
  else
    lags = '0';
  end

  [hvalue,hlabel] = uiLabelEdit(hvalue,parent,...
	'Number of Lags',padString(lags,2),'svdVecsLagsTag');
  state.svdVecs.handles = [state.svdVecs.handles hlabel hvalue];

  if isfield(state,'svdVecs') && isfield(state.svdVecs,'vectorIndicesStr')
    vecs = state.svdVecs.vectorIndicesStr;
  else
    vecs = ['1:' num2str(nChannels)];
  end

  [hvalue,hlabel] = uiLabelEdit(hvalue,parent,...
	'Vector Indices',padString(vecs,10),'svdVecsVectorIndicesTag');
  state.svdVecs.handles = [state.svdVecs.handles hlabel hvalue];

  pos=get(hfirst,'Position');

  if isfield(state,'svdVecs') && isfield(state.svdVecs,'windowSize')
    w = num2str(state.svdVecs.windowSize);
  else
    w = '64';
  end
  [hvalue,hlabel] = uiLabelEdit([pos(1) pos(2)-3],parent,...
      'Window Size',padString(w,3),'svdVecsWindowSizeTag');
  state.svdVecs.handles = [state.svdVecs.handles hlabel hvalue];
  
  if isfield(state,'svdVecs') && isfield(state.svdVecs,'windowShift')
    wshift = num2str(state.svdVecs.windowShift);
  else
    wshift = '32';
  end
  [hvalue,hlabel] = uiLabelEdit(hvalue,parent,'Window Shift',...
      padString(wshift,3),'svdVecsWindowShiftTag');
  state.svdVecs.handles = [state.svdVecs.handles hlabel hvalue];
  
  lastPosition = get(hvalue,'Position');
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(command,'destroy')
  
  if isfield(state,'svdVecs') && isfield(state.svdVecs,'handles')
    state = svdVecsGUI('read',state);
    for h = state.svdVecs.handles
      delete(h);
    end
  end
  state.svdVecs.handles = [];
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(command,'read')
  
  state.svdVecs.channelsStr = depadString(get(findobj('Tag','svdVecsChannelsTag'),'String'));
  state.svdVecs.channels = str2num(state.svdVecs.channelsStr);
  state.svdVecs.lags = str2num(get(findobj('Tag','svdVecsLagsTag'),'String'));
  state.svdVecs.vectorIndicesStr = depadString(get(findobj('Tag','svdVecsVectorIndicesTag'),'String'));
  state.svdVecs.vectorIndices = str2num(state.svdVecs.vectorIndicesStr);
  state.svdVecs.windowSize = str2num(get(findobj('Tag','svdVecsWindowSizeTag'),'String'));
  state.svdVecs.windowShift = str2num(get(findobj('Tag','svdVecsWindowShiftTag'),'String'));
  

end
