function [handleEdit,handleText] = uiLabelEdit(handleToCopyOrPosition,parent,label,initialValue,valueTag,labelTag)
% [handleEdit,handleText] = uiLabelEdit(handleToCopyOrPosition,parent,label,initialValue,valueTag,labelTag)
% handleToCopyOrPosition: uicontrol to copy and start first uicontrol just to right of, or
%     position vector [x,y] for first uicontrol
%   parent: uicontrol serving as pane holding these uicontrols
% label: text for label
% initialValue: initial text for value of edit box
% valueTag: tag for value uicontrol edit box
% labelTag: (optional) tag for label uicontrol
%
%  handleEdit: handle to edit box
%  handleText: handle to text box for label

if nargin < 6
  labelTag = '';
end


if length(handleToCopyOrPosition) > 1
  xy = handleToCopyOrPosition;
  handleText = uicontrol('Style','Text','String',label,...
      'FontSize',12,'FontWeight','bold',...
      'Units','character',...
      'Parent',parent,'Position',[xy(1) xy(2)-0.5 length(label)*1.5 2],...
      'Callback','');
else
  handle = handleToCopyOrPosition;
  handleText = copyobj(handle,parent);
  pos = get(handleText,'Position');
  set(handleText,'Style','text','String',label,...
      'Position',[pos(1)+pos(3)+1 pos(2)-0.5 length(label)*1.5 2],...
      'Callback','','Tag',labelTag);
end

handleEdit = copyobj(handleText,parent);
pos = get(handleEdit,'Position');
set(handleEdit,'Style','edit','String',initialValue,...
    'Position',[pos(1)+pos(3)+1 pos(2)+0.5 length(initialValue)*1.5 2],...
    'Callback','','Tag',valueTag);

