import numpy as np
driverText = """recursionlevel 5
eye -4 0.25 0
look 1 0 0
up 0 1 0
d -4
bounds -4 4 -4 4
res 512 512
ambient 0.5 0.7 1.0
{}
sphere 10000000005 0 0 10000000000 0.1 0.1 0.1 0.73 0.73 0.73 0.0 0.0 0.0 0.0 0.0 0.0 0
sphere 0 10000000005 0 10000000000 0.1 0.1 0.1 0.73 0.73 0.73 0.0 0.0 0.0 0.0 0.0 0.0 0
model 1.0 0.0 0.0 90 5 0 -5 0 checker.obj
sphere 0 0 -10000000005 10000000000 0.1 0.1 0.1 0.3 0.9 0.3 0.0 0.0 0.0 0.0 0.0 0.0 0
sphere 0 0 10000000005 10000000000 0.1 0.1 0.1 0.9 0.3 0.3 0.0 0.0 0.0 0.0 0.0 0.0 0
sphere 3 -3.75 -2 1.25 0.1 0.1 0.1 0.0 0.0 0.0 0.9 0.9 0.9 0.9 0.9 0.9 0
sphere 2.5 -3.75 2 1.25 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 2
"""

numLights = 15
lights = ""
for i in range(numLights):
    while True:
        lightPos = np.random.uniform(-1, 1, 2)
        if np.dot(lightPos, lightPos) < 1:
            break
    light = "light {0} 4 {1} 1 {2} {2} {2}".format(lightPos[0], lightPos[1], 1/numLights)
    lights = lights + light
    if i < numLights-1:
        lights += '\n'
f = open("driver03.txt", 'w')
f.write(driverText.format(lights))
f.close()
