import numpy as np
driverText = """intermediate
recursionlevel 5
eye -5 0 0
look 0 0 0
up 0 1 0
d -5
bounds -4 4 -4 4
res 512 512
ambient 0.1 0.1 0.1
light -5 0 0 1 1.0 1.0 1.0
{}
"""

colors = [(0.5, 0, 0), (0, 0.5, 0), (0, 0, 0.5), (0.5, 0.5, 0), (0.5, 0, 0.5), (0, 0.5, 0.5)]

bigSphere = "sphere 5 0 0 3 0.1 0.1 0.1 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0\n"

spheres = bigSphere
depths = np.linspace(-10, 7.5, 70)
for depth in depths:
    for i in range(6):
        theta = (i/6)*2*np.pi

        x = 3*depth
        y = (10 - abs(depth))*np.cos(theta + (depth/5)* 2*np.pi)
        z = (10 - abs(depth))*np.sin(theta + (depth/5)*2*np.pi)

        r = (10 - abs(depth))/8

        sphere = "sphere {} {} {} {} 0.1 0.1 0.1 {} {} {} 0.5 0.5 0.5 0.5 0.5 0.5 0\n".format(x, y, z, r, *colors[i-1])
        spheres = spheres + sphere


f = open("CImplementation/driverSpiral.txt", 'w')
f.write(driverText.format(spheres))
f.close()
