#ifndef _FUNCTIONS_H
#define _FUNCTIONS_H

#include <vector>
using namespace std;

// STATICS params[i] should be in [0, 1024].
double geo_eval( const vector<double> &params );

// ROSENBROCK params[i] should be in [-2.048, 2.047].
double rosenbrock_eval    (const vector<double> &params);
double rot_rosenbrock_eval(const vector<double> &args  );

// F8F2 params[i] should be in [-2.048, 2.047].
double f8f2_eval    (const vector<double> &params);
double rot_f8f2_eval(const vector<double> &args  );

// RANA params[i] should be in [-512, 511].
double rana_eval    (const vector<double> &params);
double rot_rana_eval(const vector<double> &args  );

// F101 params[i] should be in [-512, 511].
double f101_eval    (const vector<double> &params);
double rot_f101_eval(const vector<double> &args  );

// SCHWEFEL params[i] should be in [-512, 511].
double schwefel_eval    (const vector<double> &params);
double rot_schwefel_eval(const vector<double> &args  );

// GRIEWANGK params[i] should be in [-512, 511].
double g1_eval           (const vector<double> &params);
double g2_eval           (const vector<double> &params);		
double g3_eval           (const vector<double> &params);
double griewangk_eval    (const vector<double> &params);
double rot_griewangk_eval(const vector<double> &args  );



#endif
