/*
 * options.h: this file is part of the Vectorizer project.
 *
 * Vectorizer, a vectorization module.
 *
 * Copyright (C) 2010 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <pouchet@cse.ohio-state.edu>
 */
#ifndef VECTORIZER_OPTIONS_H
# define VECTORIZER_OPTIONS_H

# include <vectorizer/common.h>

struct s_vectorizer_options
{
  // Preprocessor
  int rose_statement_preprocessor;

  // Translator
  int mark_par_loops;
  int mark_vect_loops;

  // Optimizer
  int vectorize_loops;     /* Perform loop transformation for
			      vectorization. */
  int keep_outer_parallel; /* Always keep first outer or 2nd outer
			      parallel loop as is. */

};

typedef struct s_vectorizer_options s_vectorizer_options_t;

BEGIN_C_DECLS

extern
s_vectorizer_options_t*
vectorizer_options_malloc ();

extern
void
vectorizer_options_free (s_vectorizer_options_t* options);

END_C_DECLS


#endif // VECTORIZER_OPTIONS_H
