/*
 * vectorizer.h: this file is part of the Vectorizer project.
 *
 * Vectorizer, a vectorization module.
 *
 * Copyright (C) 2010 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <pouchet@cse.ohio-state.edu>
 */
#ifndef VECTORIZER_VECTORIZER_H
# define VECTORIZER_VECTORIZER_H

# include <vectorizer/common.h>

# ifndef LINEAR_VALUE_IS_LONGLONG
#  define LINEAR_VALUE_IS_LONGLONG
# endif
# ifndef SCOPLIB_INT_T_IS_LONGLONG
#  define SCOPLIB_INT_T_IS_LONGLONG
# endif
# define CLOOG_SUPPORTS_SCOPLIB
# include <scoplib/scop.h>
# include <cloog/cloog.h>
# include <cloog/clast.h>

# include <vectorizer/options.h>



BEGIN_C_DECLS

extern
int
vectorizer (scoplib_scop_p scop, struct clast_stmt* root,
	    s_vectorizer_options_t* options);


END_C_DECLS


#endif // VECTORIZER_VECTORIZER_H
