/*
 * options.c: this file is part of the Vectorizer project.
 *
 * Vectorizer, a vectorization module.
 *
 * Copyright (C) 2010 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * The complete GNU Lesser General Public Licence Notice can be found
 * as the `COPYING.LESSER' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <pouchet@cse.ohio-state.edu>
 */
#if HAVE_CONFIG_H
# include <vectorizer/config.h>
#endif

#include <vectorizer/common.h>
#include <vectorizer/options.h>


s_vectorizer_options_t*
vectorizer_options_malloc ()
{
  s_vectorizer_options_t* options = XMALLOC(s_vectorizer_options_t, 1);

  options->rose_statement_preprocessor = 0;
  options->mark_par_loops = 1;
  options->mark_vect_loops = 1;
  options->vectorize_loops = 1;
  options->keep_outer_parallel = 1;

  return options;
}


void
vectorizer_options_free (s_vectorizer_options_t* opts)
{
  XFREE(opts);
}
