dnl
dnl letsee.m4: this file is part of the LetSee project.
dnl
dnl LetSee, the LEgal Transformation SpacE Explorator.
dnl
dnl Copyright (C) 2006,2007,2008,2009 Louis-Noel Pouchet
dnl
dnl This program is free software; you can redistribute it and/or
dnl modify it under the terms of the GNU General Public License
dnl as published by the Free Software Foundation; either version 2
dnl of the License, or (at your option) any later version.
dnl
dnl The complete GNU General Public Licence Notice can be found as the
dnl `COPYING' file in the root directory.
dnl
dnl Author:
dnl Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
dnl


AC_DEFUN([LS_ARG_LIBS_DEPENDENCIES],
[
dnl Add $prefix to the library path (convenience).
  if test -e ${prefix}/include; then
    CPPFLAGS="${CPPFLAGS} -I${prefix}/include"
    CFLAGS="${CFLAGS} -I${prefix}/include"
  fi;
  if test -e ${prefix}/lib; then
    LDFLAGS="${LDFLAGS} -L${prefix}/lib"
  fi;
dnl Offer --with-fm.
  AC_ARG_WITH(fm,
	      AC_HELP_STRING([--with-fm=DIR],
              	             [DIR Location of FM package]),
              [with_fm=$withval;
	       CPPFLAGS="${CPPFLAGS} -I$withval/include";
	       LDFLAGS="${LDFLAGS} -L$withval/lib"
	      ],
              [with_fm=yes])
dnl Check for fm existence.
  AS_IF([test "x$with_fm" != xno],
	[AC_CHECK_LIB([fm], [fm_solver],
	 [LIBS="-lfm $LIBS";
	  AC_DEFINE([HAVE_LIBFM], [1], [Define if you have libfm])
         ],
         [if test "x$with_fm" != xcheck; then
           AC_MSG_FAILURE([Test for FM failed. Use --with-fm to specify libfm path.])
          fi
         ])
	])
dnl Offer --with-candl.
  AC_ARG_WITH(candl,
	      AC_HELP_STRING([--with-candl=DIR],
              	             [DIR Location of CANDL package]),
              [with_candl=$withval;
	       CPPFLAGS="${CPPFLAGS} -I$withval/include";
	       LDFLAGS="${LDFLAGS} -L$withval/lib"
	      ],
              [with_candl=yes])
dnl Check for candl existence.
  AS_IF([test "x$with_candl" != xno],
	[AC_CHECK_LIB([candl], [candl_dependence],
	 [LIBS="-lcandl $LIBS";
	  AC_DEFINE([HAVE_LIBCANDL], [1], [Define if you have libcandl])
         ],
         [if test "x$with_candl" != xcheck; then
           AC_MSG_FAILURE([Test for Candl failed. Use --with-candl to specify libcandl path.])
          fi
         ])
	])
dnl Offer --with-pocc-utils.
  AC_ARG_WITH(pocc-utils,
	      AC_HELP_STRING([--with-pocc-utils=DIR],
              	             [DIR Location of pocc-utils package]),
              [with_pocc_utils=$withval;
	       CPPFLAGS="${CPPFLAGS} -I$withval/include";
	       LDFLAGS="${LDFLAGS} -L$withval/lib"
	      ],
              [with_pocc_utils=check])
dnl Check for pocc-utils existence.
  AS_IF([test "x$with_pocc_utils" != xno],
	[AC_CHECK_LIB([pocc-utils], [pocc_utils_options_malloc],
	 [LIBS="-lpocc-utils $LIBS";
	  AC_DEFINE([HAVE_LIBPOCC_UTILS], [1], [Define if you have libpocc-utils])
         ],
         [if test "x$with_pocc_utils" != xcheck; then
           AC_MSG_FAILURE([Test for POCC-UTILS failed. Use --with-pocc-utils to specify libpocc-utils path.])
          fi
         ])
	])
dnl Offer --with-piplib.
  AC_ARG_WITH(piplib,
	      AC_HELP_STRING([--with-piplib=DIR],
              	             [DIR Location of PipLib package]),
              [with_piplib=$withval;
	       CPPFLAGS="${CPPFLAGS} -I$withval/include";
	       LDFLAGS="${LDFLAGS} -L$withval/lib"
	      ],
              [with_piplib=check])
dnl Check for piplib existence.
  AS_IF([test "x$with_piplib" != xno],
	[AC_CHECK_LIB([piplib64], [pip_solve],
	 [LIBS="-lpiplib64 $LIBS";
	  AC_DEFINE([HAVE_LIBPIPLIB], [1], [Define if you have libpiplib64])
         ],
         [if test "x$with_piplib" != xcheck; then
           AC_MSG_FAILURE([--with-piplib was given, but test for piplib failed])
          fi
         ])
	])
dnl Offer --with-scoplib.
  AC_ARG_WITH(scoplib,
	      AC_HELP_STRING([--with-scoplib=DIR],
              	             [DIR Location of ScopLib package]),
              [with_scoplib=$withval;
	       CPPFLAGS="${CPPFLAGS} -I$withval/include";
	       LDFLAGS="${LDFLAGS} -L$withval/lib"
	      ],
              [with_scoplib=check])
dnl Check for scoplib existence.
  AS_IF([test "x$with_scoplib" != xno],
	[AC_CHECK_LIB([scoplib], [scoplib_scop_read],
	 [LIBS="-lscoplib $LIBS";
	  AC_DEFINE([HAVE_LIBSCOPLIB], [1], [Define if you have libscoplib])
         ],
         [if test "x$with_scoplib" != xcheck; then
           AC_MSG_FAILURE([Test for ScopLib failed. Use --with-scoplib to specify libscoplib path.])
          fi
         ])
	])
])
