/*
 * dependence.h: this file is part of the LetSee project.
 *
 * LetSee, the LEgal Transformation SpacE Explorator.
 *
 * Copyright (C) 2008 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The complete GNU General Public Licence Notice can be found as the
 * `COPYING' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 *
 */

#ifndef LETSEE_DEPENDENCE_H
# define LETSEE_DEPENDENCE_H

# include <stdio.h>
# include <letsee/common.h>

# define LINEAR_VALUE_IS_LONGLONG
# include <candl/dependence.h>

# define CANDL_DEP_TAG(val,tag) (((s_dependence_tags_t*)(val->usr))->tag)


BEGIN_C_DECLS

struct s_dependence_tags
{
  int solved;	/** LetSee <boolean for dependence satisfaction>        **/
  int id;	/** LetSee <uid of the dependence (computed in LetSee)> **/
  void* tag;	/** LetSee <tag to add extra info to a dependence>      **/
};
typedef struct s_dependence_tags s_dependence_tags_t;
typedef CandlDependence s_candl_dependence_t;


s_dependence_tags_t*	ls_dependence_tags_alloc ();
void			ls_dependence_tags_free (s_dependence_tags_t*);
void			ls_dependence_init (s_candl_dependence_t*);
void			ls_dependence_clear (s_candl_dependence_t*);

END_C_DECLS


#endif // LETSEE_DEPENDENCE_H
