/*
 * explorer.h: this file is part of the LetSee project.
 *
 * LetSee, the LEgal Transformation SpacE Explorator.
 *
 * Copyright (C) 2006,2007,2008 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The complete GNU General Public Licence Notice can be found as the
 * `COPYING' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 *
 */
#ifndef LETSEE_EXPLORER_H
# define LETSEE_EXPLORER_H

# define MAX_CYCLES_SIZE 10000
# define LS_EXIT_ERROR 1
# define LS_EXIT_OK    0

# include <sys/types.h>
# include <unistd.h>
# include <sys/uio.h>
# include <stdio.h>
# include <stdlib.h>
# include <limits.h>
# include <time.h>

# include <letsee/common.h>
# include <letsee/options.h>
# include <letsee/space.h>
# include <fm/solution.h>
# include <fm/system.h>
# include <fm/solver.h>
# include <candl/candl.h>
# include <letsee/transformations.h>

// Dirty hack: the explorer_t structure is used in other heuristic files.
// FIXME: fix that.
BEGIN_C_DECLS

typedef unsigned long long int cycles_t;

struct s_ls_explorer
{
  unsigned* ids;
  cycles_t* cycles;
  s_fm_vector_t** draws;
  s_fm_vector_t*** u_draws;
  unsigned count;
  unsigned size;
  unsigned dimension;
};

typedef struct s_ls_explorer s_ls_explorer_t;

END_C_DECLS

# include <letsee/heuristics.h>
# include <letsee/heuristic-h1.h>
# include <letsee/heuristic-m1.h>
# include <letsee/heuristic-random.h>
# include <letsee/heuristic-exhaust.h>
# include <letsee/heuristic-pluto.h>
# include <letsee/heuristic-plutocc.h>

BEGIN_C_DECLS

typedef int (*relax_function_t)(s_fm_solution_t*,
				s_fm_vector_t*,
				z_type_t*,
				z_type_t*,
				int*,
				int*);


/**
 * Execute a transformation on the target machine (rely on the
 * src/onetest.sh script)
 *
 */
extern
cycles_t
ls_explorer_exectrans (CandlProgram* program,
		       s_ls_options_t* options,
		       s_fm_vector_t** draw,
		       unsigned id);
/**
 * Execute the original code on the target machine (rely on the
 * src/origtest.sh script)
 *
 */
extern
cycles_t
ls_explorer_execorig (s_ls_options_t* options);


/**
 * Helper function to execute a command.
 */
extern
cycles_t
ls_explorer_execprog (char** args);

/**
 * Filter the results stored in the data structure, provided thresold
 * option.
 *
 */
extern
void
ls_explorer_heuristic_filter (s_ls_options_t* options,
			      s_ls_explorer_t* data);


/*
 *
 *
 */
extern
int
ls_explorer_transfo_exists (s_ls_explorer_t* data,
			    s_fm_vector_t* draw);

/*
 *
 *
 */
extern
void
ls_explorer (s_ls_space_t* space,
	     CandlProgram* program,
	     s_ls_options_t* options);

END_C_DECLS


#endif // LETSEE_EXPLORER_H
