/*
 * fusionspace.h: this file is part of the LetSee project.
 *
 * LetSee, the LEgal Transformation SpacE Explorator.
 *
 * Copyright (C) 2008 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The complete GNU General Public Licence Notice can be found as the
 * `COPYING' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 *
 */
#ifndef LETSEE_FUSIONSPACE_H
# define LETSEE_FUSIONSPACE_H

# include <letsee/common.h>
# include <letsee/options.h>
# include <letsee/space.h>
# include <letsee/transformations.h>
# include <letsee/farkas.h>
# include <letsee/graph.h>
# include <letsee/schedspace.h>
# include <fm/piptools.h>
# include <fm/solution.h>
# include <fm/system.h>
# include <fm/solver.h>
# include <fm/compsol.h>
# include <candl/candl.h>



BEGIN_C_DECLS

extern
s_ls_space_t*
ls_fusionspace_build (CandlProgram* program,
		     CandlDependence* dependences,
		     s_ls_options_t* options);

extern
void
ls_fusionspace_normalize_space (CandlProgram* program,
				s_ls_options_t* options,
				s_ls_space_t* space,
				z_type_t lb,
				z_type_t Ub);

END_C_DECLS


#endif // LETSEE_FUSIONSPACE_H
