/*
 * transformations.h: this file is part of the LetSee project.
 *
 * LetSee, the LEgal Transformation SpacE Explorator.
 *
 * Copyright (C) 2006 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The complete GNU General Public Licence Notice can be found as the
 * `COPYING' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 *
 */
#ifndef LETSEE_TRANSFORMATIONS_H
# define LETSEE_TRANSFORMATIONS_H

# include <letsee/common.h>
# include <letsee/options.h>
# include <letsee/space.h>
# include <fm/solution.h>
# include <fm/system.h>
# include <fm/solver.h>
# include <candl/candl.h>


BEGIN_C_DECLS


extern
int
ls_transformations_generate (s_fm_vector_t* draw,
			     CandlProgram* program,
			     s_ls_options_t* options,
			     unsigned count);

extern
int
ls_transformations_generate_multi (s_fm_vector_t** draw,
				   CandlProgram* program,
				   s_ls_options_t* options,
				   unsigned count);

extern
void
ls_transformations (s_ls_space_t* space,
		    CandlProgram* program,
		    s_ls_options_t* options);

END_C_DECLS


#endif // LETSEE_TRANSFORMATIONS_H
