/*
 * options.c: this file is part of the LetSee project.
 *
 * LetSee, the LEgal Transformation SpacE Explorator.
 *
 * Copyright (C) 2006 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The complete GNU General Public Licence Notice can be found as the
 * `COPYING' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 *
 */
#if HAVE_CONFIG_H
# include <letsee/config.h>
#endif

#include <letsee/common.h>
#include <letsee/options.h>


s_ls_options_t*
ls_options_malloc ()
{
  int i;
  s_ls_options_t* options = XMALLOC(s_ls_options_t, 1);

  options->in_file = NULL;
  options->out_file = stdout;
  options->has_out_file = 0;
  Z_INIT(options->lb);
  Z_ASSIGN_SI(options->lb, -1);
  Z_INIT(options->Ub);
  Z_ASSIGN_SI(options->Ub, 1);
  Z_INIT(options->plb);
  Z_ASSIGN_SI(options->plb, -1);
  Z_INIT(options->pUb);
  Z_ASSIGN_SI(options->pUb, 1);
  Z_INIT(options->clb);
  Z_ASSIGN_SI(options->clb, -1);
  Z_INIT(options->cUb);
  Z_ASSIGN_SI(options->cUb, 1);
  options->fm_mode = FM_SOLVER_FAST;
  options->verbose = 0;
  options->create_schedfiles = 1;
  options->type = LS_TYPE_OSPACE;
  options->transfo_dir = strdup ("transformations");
  options->load_file = NULL;
  options->normalize_space = 0;
  options->heuristic = LS_HEURISTIC_EXHAUST;
  options->input_file = NULL;
  options->compile_line = NULL;
  options->thresold = 5;
  options->rtries = 20;
  options->noredundancy_solver = 0;
  options->scheme_m1 = NULL;

  // TEST
  options->tile = 0;
  options->tile_factor = 0;
  options->backtrack_mode = LS_BACKTRACK_DISABLE;
  options->maxscale_solver = 0;

  // John.
  options->vector = NULL;
  options->vector2 = NULL;

  options->traffic_order = 0;

  // lppcc
  options->prune_oset = 0;

  // pocc
  options->pocc_utils = NULL;

  return options;
}


void
ls_options_free (s_ls_options_t* options)
{
  if (options->has_out_file)
    fclose (options->out_file);
  Z_CLEAR(options->lb);
  Z_CLEAR(options->Ub);
  Z_CLEAR(options->plb);
  Z_CLEAR(options->pUb);
  Z_CLEAR(options->clb);
  Z_CLEAR(options->cUb);
  XFREE(options->transfo_dir);
  XFREE(options->input_file);
  XFREE(options->compile_line);
  XFREE(options->load_file);
  fm_vector_free (options->vector);
  fm_vector_free (options->vector2);
  XFREE(options->scheme_m1);
}


void
ls_options_print (FILE* stream, s_ls_options_t* options)
{
  fprintf (stream, "in-file: %p\n", options->in_file);
  fprintf (stream, "out-file: %p\n", options->out_file);
  fprintf (stream, "has-out-file: %d\n", options->has_out_file);
  fprintf (stream, "lb: %d\n", options->lb);
  fprintf (stream, "Ub: %d\n", options->Ub);
  fprintf (stream, "plb: %d\n", options->plb);
  fprintf (stream, "pUb: %d\n", options->pUb);
  fprintf (stream, "clb: %d\n", options->clb);
  fprintf (stream, "cUb: %d\n", options->cUb);
  fprintf (stream, "fm-mode: %d\n", options->fm_mode);
  fprintf (stream, "verbose: %d\n", options->verbose);
  fprintf (stream, "create-schedfiles: %d\n", options->create_schedfiles);
  fprintf (stream, "transfo-dir: %s\n", options->transfo_dir);
  fprintf (stream, "type: %d\n", options->type);
  fprintf (stream, "space-normalization: %d\n", options->normalize_space);
  fprintf (stream, "walk heuristic: %d\n", options->heuristic);
  fprintf (stream, "input file: %s\n", options->input_file);
  fprintf (stream, "compile line: %s\n", options->compile_line);
  fprintf (stream, "thresold: %d\n", options->thresold);
  fprintf (stream, "rtries: %d\n", options->rtries);
  fprintf (stream, "le-fur: %d\n", options->noredundancy_solver);
  fprintf (stream, "load-space: %s\n", options->load_file);
  fprintf (stream, "backtrak-mode: %s\n", options->backtrack_mode);
  fprintf (stream, "traffic-order: %s\n", options->traffic_order);
  fprintf (stream, "maxscale-solver: %s\n", options->maxscale_solver);
  fprintf (stream, "prune-oset: %s\n", options->prune_oset);
}
