/*
 * space.c: this file is part of the LetSee project.
 *
 * LetSee, the LEgal Transformation SpacE Explorator.
 *
 * Copyright (C) 2006,2007,2008 Louis-Noel Pouchet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The complete GNU General Public Licence Notice can be found as the
 * `COPYING' file in the root directory.
 *
 * Author:
 * Louis-Noel Pouchet <Louis-Noel.Pouchet@inria.fr>
 *
 */
#if HAVE_CONFIG_H
# include <letsee/config.h>
#endif

#include <letsee/space.h>
#include <letsee/lspace.h>
#include <letsee/schedspace.h>
#include <letsee/fusionspace.h>
#include <letsee/fdspace.h>
#include <letsee/fsspace.h>


s_ls_space_t*
ls_space_alloc ()
{
  s_ls_space_t* space = XMALLOC(s_ls_space_t, 1);
  space->polyhedron = NULL;
  space->u_polyhedron = NULL;
  space->u_compacted = NULL;
  space->size = 0;
  space->dimension = 0;
  // FIXME: Temporarily extend the space structure.
  space->program = NULL;
  space->dependences = NULL;
}


void
ls_space_free (s_ls_space_t* space)
{
  int i;

  if (space == NULL)
    return;

  if (space->u_polyhedron)
    for (i = 0; space->u_polyhedron && i < space->dimension; ++i)
      fm_solution_free (space->u_polyhedron[i]);
  else
    fm_solution_free (space->polyhedron);
  if (space->u_compacted)
    for (i = 0; space->u_compacted && i < space->dimension; ++i)
      fm_compsol_free (space->u_compacted[i]);
/*   // FIXME: Temporarily extend the space structure. */
/*   if (space->dependences) */
/*     candl_dependence_free (space->dependences); */
/*   if (space->program) */
/*     candl_program_free (space->program); */
}




/**
 * Compute the legal space, as a set of polytopes (one per schedule
 * dimension).
 *
 */
s_ls_space_t*
ls_space (CandlProgram* program,
	  CandlDependence* dependences,
	  s_ls_options_t* options)
{
  s_ls_space_t* space;

  if (options->verbose)
    fprintf(options->out_file, "[LetSee] Starting space computation\n");

  // Preprocess the dependence graph, to add the 'usr' internal
  // structure.
  ls_dependence_init (dependences);

  if (options->type == LS_TYPE_OSPACE)
    space = ls_lspace_build (program, dependences, options);
  else if (options->type == LS_TYPE_MULTI)
    space = ls_schedspace_build (program, dependences, options);
  else if (options->type == LS_TYPE_FUSION)
    space = ls_fusionspace_build (program, dependences, options);
  else if (options->type == LS_TYPE_FD)
    space = ls_fdspace_build (program, dependences, options);
  else if (options->type == LS_TYPE_FS)
    space = ls_fsspace_build (program, dependences, options);
/*   else if (options->type == LS_TYPE_FS2) */
/*     space = ls_fsspace2_build (program, dependences, options); */
  else
    assert (! "Space construction type not supported anymore!");

  // Clear the dependence graph, to remove the 'usr' internal
  // structure.
  ls_dependence_clear (dependences);

  if (options->verbose)
    fprintf(options->out_file, "[LetSee] Legal space computed\n");

  return space;
}
